---
name: db.dropcolumn.py
description: Drops a column from selected attribute table.
keywords: [ database, attribute table ]
---

# db.dropcolumn.py

Drops a column from selected attribute table.

=== "Command line"

    **db.dropcolumn.py**
    [**-f**]
    **table**=*name*
    **column**=*name*
    [**database**=*name*]
    [**driver**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.dropcolumn.py table=name column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.dropcolumn.py***",
        **table**,
        **column**,
        **database**=*None*,
        **driver**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.dropcolumn.py", table="name", column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_dropcolumn_py*(**table**,
        **column**,
        **database**=*None*,
        **driver**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_dropcolumn_py(table="name", column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.dropcolumn* drops a column from an attribute table. If the **-f**
force flag is not given then nothing is removed, instead a preview of
the action to be taken is printed.

## NOTES

*db.dropcolumn* is a front-end to *db.execute* to allow easier usage
with a special workaround for the SQLite driver to support column drop
also for SQLite tables.

## EXAMPLE

Dropping a column (North Carolina sample dataset):

```sh
# work on own copy
g.copy vect=roadsmajor,myroads
db.describe -c myroads

# only shows what would happen:
db.dropcolumn myroads column=SHAPE_LEN

# actually drops the column
db.dropcolumn -f myroads column=SHAPE_LEN

db.describe -c myroads
```

## SEE ALSO

*[db.describe](db.describe.md), [db.droptable](db.droptable.md),
[db.execute](db.execute.md), [v.db.dropcolumn](v.db.dropcolumn.md),
[GRASS SQL interface](sql.md)*

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [db.dropcolumn source code](https://github.com/OSGeo/grass/tree/main/scripts/db.dropcolumn)
([history](https://github.com/OSGeo/grass/commits/main/scripts/db.dropcolumn))  
Latest change: Wednesday Mar 12 22:27:28 2025 in commit [0095480](https://github.com/OSGeo/grass/commit/0095480779ff07f10b76a859388850c52b9dccbd)
