---
name: db.execute
description: Executes any SQL statement. For SELECT statements use 'db.select'.
keywords: [ database, attribute table, SQL ]
---

# db.execute

Executes any SQL statement.

For SELECT statements use 'db.select'.

=== "Command line"

    **db.execute**
    [**-i**]
    [**sql**=*sql_query*]
    [**input**=*name*]
    [**driver**=*name*]
    [**database**=*name*]
    [**schema**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.execute
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.execute***",
        **sql**=*None*,
        **input**=*None*,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **schema**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.execute")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_execute*(**sql**=*None*,
        **input**=*None*,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **schema**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_execute()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **sql**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;SQL statement  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: update rybniky set kapri = 'hodne' where kapri = 'malo'  
    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing SQL statement(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **schema**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore SQL errors and continue  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **sql** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;SQL statement  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: update rybniky set kapri = 'hodne' where kapri = 'malo'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing SQL statement(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore SQL errors and continue  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **sql** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;SQL statement  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: update rybniky set kapri = 'hodne' where kapri = 'malo'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing SQL statement(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore SQL errors and continue  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.execute* allows the user to execute SQL statements.

## NOTES

*db.execute* only executes SQL statements and does not return any data.
If you need data returned from the database, use
*[db.select](db.select.md)*.

If parameters for database connection are already set with
*[db.connect](db.connect.md)*, they are taken as default values and do
not need to be specified each time.

If you have a large number of SQL commands to process, it is much faster
to place all the SQL statements into a text file and use **input** file
parameter than it is to process each statement individually in a loop.
If multiple instruction lines are given, each SQL line must end with a
semicolon.

Please see the individual *[GRASS SQL interface](sql.md)* for how to
create a new database.

## EXAMPLES

Create a new table with columns 'cat' and 'soiltype':

```sh
db.execute sql="CREATE TABLE soils (cat integer, soiltype varchar(10))"
```

Create a new table using a file with SQL statements

```sh
db.execute driver=odbc database=grassdb input=file.sql
```

Insert new row into attribute table:

```sh
db.execute sql="INSERT INTO mysites (id,name,east,north) values (30,'Ala',1657340,5072301)"
```

Update attribute entries to new value based on SQL rule:

```sh
db.execute sql="UPDATE roads SET travelcost=5 WHERE cat=1"
```

Update attribute entries to new value based on SQL rule:

```sh
db.execute sql="UPDATE dourokukan SET testc=50 WHERE testc is NULL"
```

Delete selected rows from attribute table:

```sh
db.execute sql="DELETE FROM gsod_stationlist WHERE latitude < -91"
```

Add new column to attribute table:

```sh
db.execute sql="ALTER TABLE roads ADD COLUMN length double"
```

Column type conversion - update new column from existing column (all
drivers except for DBF):

```sh
# 'z_value' is varchar and 'z' is double precision:
echo "UPDATE geodetic_pts SET z = CAST(z_value AS numeric)" | db.execute input=-
```

Drop column from attribute table:

```sh
db.execute sql="ALTER TABLE roads DROP COLUMN length"
```

Drop table (not supported by all drivers):

```sh
db.execute sql="DROP TABLE fmacopy"
```

Update attribute with multiple SQL instructions in file (e.g.,
`file.sql`, instruction line must end with a semicolon):

```sh
UPDATE roads SET travelcost=5 WHERE cat=1;
UPDATE roads SET travelcost=2 WHERE cat=2;

db.execute input=file.sql
```

Join table 'myroads' to table 'extratab' based on common 'cat' column
values (not supported by DBF driver):

```sh
db.execute sql="UPDATE extratab SET names=(SELECT label FROM myroads WHERE extratab.cat=myroads.cat)"
```

## SEE ALSO

*[db.columns](db.columns.md), [db.describe](db.describe.md),
[db.drivers](db.drivers.md), [db.droptable](db.droptable.md),
[db.login](db.login.md), [db.select](db.select.md),
[db.tables](db.tables.md),*

*[GRASS SQL interface](sql.md)*

## AUTHOR

CERL

## SOURCE CODE

Available at: [db.execute source code](https://github.com/OSGeo/grass/tree/main/db/db.execute)
([history](https://github.com/OSGeo/grass/commits/main/db/db.execute))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
