---
name: g.citation.py
description: Provide scientific citation for GRASS modules and add-ons.
keywords: [ general, metadata, citation ]
---

# g.citation.py

Provide scientific citation for GRASS modules and add-ons.

=== "Command line"

    **g.citation.py**
    [**-ads**]
    [**module**=*string*]
    **format**=*string*
    [**style**=*string*]
    [**vertical_separator**=*string*]
    [**output**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.citation.py module=string format=bibtex
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***g.citation.py***",
        **module**=*None*,
        **format**=*"bibtex"*,
        **style**=*"harvard1"*,
        **vertical_separator**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("g.citation.py", module="string", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_citation_py*(**module**=*None*,
        **format**=*"bibtex"*,
        **style**=*"harvard1"*,
        **vertical_separator**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_citation_py(module="string", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **module**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS GIS module to be cited  
    **format**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Citation format or style  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bibtex, cff, json, pretty-json, csl-json, citeproc, chicago-footnote, dict, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bibtex*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bibtex**: BibTeX  
    &nbsp;&nbsp;&nbsp;&nbsp;**cff**: Citation File Format  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON  
    &nbsp;&nbsp;&nbsp;&nbsp;**pretty-json**: Pretty printed JSON  
    &nbsp;&nbsp;&nbsp;&nbsp;**csl-json**: Citation Style Language JSON (citeproc JSON) format  
    &nbsp;&nbsp;&nbsp;&nbsp;**citeproc**: Use the citeproc-py library to create the citation (CSL)  
    &nbsp;&nbsp;&nbsp;&nbsp;**chicago-footnote**: Chicago style for footnotes  
    &nbsp;&nbsp;&nbsp;&nbsp;**dict**: Pretty printed Python dictionary  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text  
    **style**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Citation style for the citeproc formatter (CSL)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *harvard1*  
    **vertical_separator**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator of individual citation records  
    &nbsp;&nbsp;&nbsp;&nbsp;Inserted before each item  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path of the output file  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide citations for all modules  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Add GRASS GIS as dependency to citation  
    &nbsp;&nbsp;&nbsp;&nbsp;Add GRASS GIS as dependency, reference, or additional citation to the citation of a module if applicable for the format (currently only CFF)  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip errors, provide warning only  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **module** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS GIS module to be cited  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Citation format or style  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bibtex, cff, json, pretty-json, csl-json, citeproc, chicago-footnote, dict, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bibtex**: BibTeX  
    &nbsp;&nbsp;&nbsp;&nbsp;**cff**: Citation File Format  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON  
    &nbsp;&nbsp;&nbsp;&nbsp;**pretty-json**: Pretty printed JSON  
    &nbsp;&nbsp;&nbsp;&nbsp;**csl-json**: Citation Style Language JSON (citeproc JSON) format  
    &nbsp;&nbsp;&nbsp;&nbsp;**citeproc**: Use the citeproc-py library to create the citation (CSL)  
    &nbsp;&nbsp;&nbsp;&nbsp;**chicago-footnote**: Chicago style for footnotes  
    &nbsp;&nbsp;&nbsp;&nbsp;**dict**: Pretty printed Python dictionary  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bibtex*  
    **style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Citation style for the citeproc formatter (CSL)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *harvard1*  
    **vertical_separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator of individual citation records  
    &nbsp;&nbsp;&nbsp;&nbsp;Inserted before each item  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path of the output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *d*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Provide citations for all modules  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add GRASS GIS as dependency to citation  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add GRASS GIS as dependency, reference, or additional citation to the citation of a module if applicable for the format (currently only CFF)  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip errors, provide warning only  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **module** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS GIS module to be cited  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Citation format or style  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bibtex, cff, json, pretty-json, csl-json, citeproc, chicago-footnote, dict, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bibtex**: BibTeX  
    &nbsp;&nbsp;&nbsp;&nbsp;**cff**: Citation File Format  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON  
    &nbsp;&nbsp;&nbsp;&nbsp;**pretty-json**: Pretty printed JSON  
    &nbsp;&nbsp;&nbsp;&nbsp;**csl-json**: Citation Style Language JSON (citeproc JSON) format  
    &nbsp;&nbsp;&nbsp;&nbsp;**citeproc**: Use the citeproc-py library to create the citation (CSL)  
    &nbsp;&nbsp;&nbsp;&nbsp;**chicago-footnote**: Chicago style for footnotes  
    &nbsp;&nbsp;&nbsp;&nbsp;**dict**: Pretty printed Python dictionary  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bibtex*  
    **style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Citation style for the citeproc formatter (CSL)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *harvard1*  
    **vertical_separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator of individual citation records  
    &nbsp;&nbsp;&nbsp;&nbsp;Inserted before each item  
    **output** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path of the output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *d*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Provide citations for all modules  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add GRASS GIS as dependency to citation  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add GRASS GIS as dependency, reference, or additional citation to the citation of a module if applicable for the format (currently only CFF)  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip errors, provide warning only  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.citation* - creates citation or metadata based on documentation of a
given module.

### Formats

#### Citation File Format

[Citation File Format](https://citation-file-format.github.io/) (CFF) is
a YAML based format for citations, specifically CITATION files to be
included with software or code as `CITATION.cff`.

#### JSON

Currently, the keys and the overall structure are subject to change, but
the plan is to stabilize it or to provide existing metadata format in
JSON. Pretty-printed version is good, e.g., for saving into files, while
the other, compact version is good for further processing.

#### Pretty printed Python dictionary

This format is essentially a dump of the internal data structure holding
the citation entry. It should not be used in scripts, i.e. further
parsed, for that there are other formats such as JSON. When this is
advantageous is exploring what information the module was able to
acquire for the citation.

## NOTES

- Don't use the `format=dict` for further processing. It is meant for
    exploration of what information the module acquired.
- The structure of the JSON output is yet not guaranteed.

## EXAMPLES

```sh
g.citation module=v.select format=plain
```

```sh
g.citation f=pretty-json -a -s | grep '"name": ' | sort | uniq
```

```sh
g.citation -s format=citeproc vsep="< p>" -a > all.html
```

## KNOWN ISSUES

- More output formats or styles are needed. The following formats were
    suggested so far: `csl,datacite,dublincore,json-ld,narcxml`
- The structure of the JSON output is not guaranteed. It reflects the
    internal structure (only the empty entries are removed).
- Version and date in CFF output are incomplete.

## SEE ALSO

*[g.search.module](https://grass.osgeo.org/grass-stable/manuals/g.search.module.html)*

## AUTHORS

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/) (ORCID:
0000-0001-5566-9236)  
Peter Loewe (ORCID: 0000-0003-2257-0517)  
Markus Neteler, [mundialis](https://www.mundialis.de) (ORCID:
0000-0003-1916-1966)

## SOURCE CODE

Available at: [g.citation source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/general/g.citation)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/general/g.citation))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
