---
name: g.copyall.py
description: Copies all or a filtered subset of files of selected type from another mapset to the current working mapset.
keywords: [ copy, general ]
---

# g.copyall.py

Copies all or a filtered subset of files of selected type from another mapset to the current working mapset.

=== "Command line"

    **g.copyall.py**
    [**-t**]
    **mapset**=*name*
    **datatype**=*string*
    [**filter**=*string*]
    [**filter_type**=*string*]
    [**output_prefix**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.copyall.py mapset=name datatype=rast
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.copyall.py***",
        **mapset**,
        **datatype**=*"rast"*,
        **filter**=*None*,
        **filter_type**=*"select all"*,
        **output_prefix**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.copyall.py", mapset="name", datatype="rast")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_copyall_py*(**mapset**,
        **datatype**=*"rast"*,
        **filter**=*None*,
        **filter_type**=*"select all"*,
        **output_prefix**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_copyall_py(mapset="name", datatype="rast")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **mapset**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset to copy files from  
    **datatype**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose type of GRASS data to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rast, vect, labels, rast3d, region, group*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rast*  
    **filter**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Search pattern to filter data files to copy  
    **filter_type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of search pattern to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *select all,  wildcards, regular expressions, extended regular expressions*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *select all*  
    **output_prefix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional prefix for output raster maps  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update vector topology to match current GRASS version  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **mapset** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset to copy files from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **datatype** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose type of GRASS data to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rast, vect, labels, rast3d, region, group*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rast*  
    **filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Search pattern to filter data files to copy  
    **filter_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of search pattern to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *select all,  wildcards, regular expressions, extended regular expressions*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *select all*  
    **output_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional prefix for output raster maps  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update vector topology to match current GRASS version  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **mapset** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset to copy files from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **datatype** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose type of GRASS data to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rast, vect, labels, rast3d, region, group*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rast*  
    **filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Search pattern to filter data files to copy  
    **filter_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of search pattern to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *select all,  wildcards, regular expressions, extended regular expressions*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *select all*  
    **output_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional prefix for output raster maps  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update vector topology to match current GRASS version  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

***g.copyall*** copies maps/files of a specified from a selected mapset
to the current working mapset. All maps/files can be copied or a subset
of maps/files specified by a wildcard pattern or regular expression.
Optionally, a prefix can be added to all files copied and vector
topology can be rebuilt to match currently running version of GRASS.

## EXAMPLES

Copy all raster maps from mapset "test" to current mapset and prefix
them with "fromtest":

```sh
g.copyall mapset=test output_prefix=fromtest
```

Copy all vector maps beginning with "s" from mapset "test" to current
mapset:

```sh
g.copyall mapset=test datatype=vect filter="s*"
```

## SEE ALSO

*[g.list](https://grass.osgeo.org/grass-stable/manuals/g.list.html),
[g.copy](https://grass.osgeo.org/grass-stable/manuals/g.copy.html)*

## AUTHOR

Michael Barton (Arizona State University, USA)

## SOURCE CODE

Available at: [g.copyall source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/general/g.copyall)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/general/g.copyall))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
