---
name: g.findetc
description: Searches for GRASS support files.
keywords: [ general, map management, scripts ]
---

# g.findetc

Searches for GRASS support files.

=== "Command line"

    **g.findetc**
    **file**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.findetc file=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.findetc***",
        **file**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.findetc", file="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_findetc*(**file**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_findetc(file="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **file**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an file or directory  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **file** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an file or directory  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **file** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an file or directory  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.findetc* is designed for Bourne shell scripts that need to search for
support data, programs and subfoldrs in any number of directories as
specified in GRASS_ADDON_ETC, plus the GRASS application etc/ directory.
This is designed for addon scripts that are installed outside the GRASS
application directory, such as a user's home or a system addon
directory.

## OUTPUT

*g.findetc* writes the full path to the file or directory to standard
output

## SEE ALSO

*[g.filename](g.filename.md), [g.findfile](g.findfile.md),
[g.gisenv](g.gisenv.md), [g.mapsets](g.mapsets.md)*

## AUTHOR

William Kyngesburye

## SOURCE CODE

Available at: [g.findetc source code](https://github.com/OSGeo/grass/tree/main/general/g.findetc)
([history](https://github.com/OSGeo/grass/commits/main/general/g.findetc))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
