---
name: g.search.modules.py
description: Search in GRASS modules using keywords
keywords: [ general, modules, search ]
---

# g.search.modules.py

Search in GRASS modules using keywords

=== "Command line"

    **g.search.modules.py**
    [**-anmkcgj**]
    [**keyword**=*string* [,*string*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.search.modules.py
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***g.search.modules.py***",
        **keyword**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("g.search.modules.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_search_modules_py*(**keyword**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_search_modules_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **keyword**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Keyword to be searched  
    &nbsp;&nbsp;&nbsp;&nbsp;List all modules if not given  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display only modules where all keywords are available (AND), default: OR  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Invert selection (logical NOT)  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Search in manual pages too (can be slow)  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Search only for the exact keyword in module keyword list  
    &nbsp;&nbsp;&nbsp;&nbsp;Instead of full text search, search only in actual keywords  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use colorized (more readable) output to terminal  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Shell script format  
    **-j**  
    &nbsp;&nbsp;&nbsp;&nbsp;JSON format  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **keyword** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Keyword to be searched  
    &nbsp;&nbsp;&nbsp;&nbsp;List all modules if not given  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *n*, *m*, *k*, *c*, *g*, *j*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display only modules where all keywords are available (AND), default: OR  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert selection (logical NOT)  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Search in manual pages too (can be slow)  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Search only for the exact keyword in module keyword list  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Instead of full text search, search only in actual keywords  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use colorized (more readable) output to terminal  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Shell script format  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;JSON format  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **keyword** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Keyword to be searched  
    &nbsp;&nbsp;&nbsp;&nbsp;List all modules if not given  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *n*, *m*, *k*, *c*, *g*, *j*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display only modules where all keywords are available (AND), default: OR  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert selection (logical NOT)  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Search in manual pages too (can be slow)  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Search only for the exact keyword in module keyword list  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Instead of full text search, search only in actual keywords  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use colorized (more readable) output to terminal  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Shell script format  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;JSON format  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.search.module* searches for given keyword in GRASS modules name,
description, keywords and optionally manpages, too. Also installed
addons are considered in the search.

## NOTES

Multiple keywords may be specified, *g.search.modules* will search for
all of them.

## EXAMPLES

Search all modules, where keywords *buffer* OR *clip* can be found:

```sh
g.search.modules keyword=buffer,clip

r.circle
    keywords: raster,buffer,geometry,circle
    description: Creates a raster map containing concentric rings around a
                 given point.

r.buffer.lowmem
    keywords: raster,buffer
    description: Creates a raster map showing buffer zones surrounding cells
                 that contain non-NULL category values. This is the low-
                 memory alternative to the classic r.buffer module.

r.buffer
    keywords: raster,buffer
    description: Creates a raster map showing buffer zones surrounding cells
                 that contain non-NULL category values.
```

Search all modules, where keywords *overlay* AND *clip* can be found
with some fancy terminal output (not shown here):

```sh
g.search.modules keyword=clip,overlay -a -c

v.clip
    keywords: vector,clip,area
    description: Extracts features of input map which overlay features
                 of clip map.

v.overlay
    keywords: vector,geometry,spatial
              query,clip,difference,intersection,union
    description: Overlays two vector maps offering clip, intersection,
                 difference, symmetrical difference, union operators.
```

Search in manual pages as well:

```sh
g.search.modules -m keyword=kapri

db.execute
    keywords: database,attribute table,SQL
    description: Executes any SQL statement. For SELECT statements use
                 'db.select'.

db.select
    keywords: database,attribute table,SQL
    description: Selects data from attribute table. Performs SQL query
                 statement(s).
```

## SEE ALSO

*[g.manual](g.manual.md)*

## AUTHORS

Jachym Cepicky, OpenGeoLabs s.r.o., Czech Republic: original author  
Anika Bettge, mundialis, Germany: addon search added

## SOURCE CODE

Available at: [g.search.modules source code](https://github.com/OSGeo/grass/tree/main/scripts/g.search.modules)
([history](https://github.com/OSGeo/grass/commits/main/scripts/g.search.modules))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
