---
name: i.ann.maskrcnn.detect.py
description: Detect features in images using a Mask R-CNN model
keywords: [ ann, vector, raster ]
---

# i.ann.maskrcnn.detect.py

Detect features in images using a Mask R-CNN model

=== "Command line"

    **i.ann.maskrcnn.detect.py**
    [**-e**]
    [**band1**=*string*]
    [**band2**=*string*]
    [**band3**=*string*]
    [**images_directory**=*name*]
    [**images_format**=*string*]
    **model**=*string*
    **classes**=*string* [,*string*,...]
    [**output_type**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.ann.maskrcnn.detect.py images_directory=name model=string classes=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.ann.maskrcnn.detect.py***",
        **band1**=*None*,
        **band2**=*None*,
        **band3**=*None*,
        **images_directory**=*None*,
        **images_format**=*None*,
        **model**,
        **classes**,
        **output_type**=*"area"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.ann.maskrcnn.detect.py", images_directory="name", model="string", classes="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_ann_maskrcnn_detect_py*(**band1**=*None*,
        **band2**=*None*,
        **band3**=*None*,
        **images_directory**=*None*,
        **images_format**=*None*,
        **model**,
        **classes**,
        **output_type**=*"area"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_ann_maskrcnn_detect_py(images_directory="name", model="string", classes="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **band1**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the first band (divided by ",")  
    **band2**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the second band (divided by ",")  
    **band3**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the third band (divided by ",")  
    **images_directory**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to a directory with external images to detect  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory  
    **images_format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format suffix of images  
    &nbsp;&nbsp;&nbsp;&nbsp;.jpg, .tiff, .png, etc.  
    **model**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the .h5 file containing the model  
    **classes**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of classes separated with ","  
    **output_type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area,  point*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;External georeferencing in the images folder (when using images_directory)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **band1** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the first band (divided by ",")  
    **band2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the second band (divided by ",")  
    **band3** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the third band (divided by ",")  
    **images_directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to a directory with external images to detect  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **images_format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format suffix of images  
    &nbsp;&nbsp;&nbsp;&nbsp;.jpg, .tiff, .png, etc.  
    **model** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the .h5 file containing the model  
    **classes** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of classes separated with ","  
    **output_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area,  point*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;External georeferencing in the images folder (when using images_directory)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **band1** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the first band (divided by ",")  
    **band2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the second band (divided by ",")  
    **band3** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to use for detection as the third band (divided by ",")  
    **images_directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to a directory with external images to detect  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **images_format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format suffix of images  
    &nbsp;&nbsp;&nbsp;&nbsp;.jpg, .tiff, .png, etc.  
    **model** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the .h5 file containing the model  
    **classes** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of classes separated with ","  
    **output_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area,  point*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;External georeferencing in the images folder (when using images_directory)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.ann.maskrcnn.detect* allows the user to use a Mask R-CNN model to
detect features in GRASS GIS raster maps or georeferenced files and
extract them either as areas or points. The module creates a separate
map for each class.

## NOTES

The detection may be used for raster maps imported in GRASS GIS or for
external files (or using both). To use raster maps in GRASS GIS, you
need to pass them in three bands following the order used during the
training, e.g. if the training has been made on RGB images, use
*band1=\*.red*, *band1=\*.green* and *band3=\*.blue*. To pass multiple
images, put more maps into *band\** parameters, divided by ",".

The detection may be used also for multiple external files. However, all
files for the detection must be in one directory specified in the
*images\_directory* parameter. Even when using only one image, the
module finds it through this parameter.

When detecting, you can use new names of classes. Classes in the model
are not referenced by their name, but by their order. It means that if
the model was trained with classes *corn,rice* and you use
*i.ann.maskrcnn.detect* with classes *zea,oryza*, zea areas will present
areas detected as corn and oryza areas will present areas detected as
rice.

If the external file is georeferenced externally (by a worldfile or an
*.aux.xml* file), please use *-e* flag.

## EXAMPLES

### Detect buildings and lakes and import them as areas

One map imported in GRASS GIS:

```sh
i.ann.maskrcnn.detect band1=map1.red band2=map1.green band3=map1.blue classes=buildings,lakes model=/home/user/Documents/logs/mask_rcnn_buildings_lakes_0100.h5
```

Two maps (map1, map2) imported in GRASS GIS:

```sh
i.ann.maskrcnn.detect band1=map1.red,map2.red band2=map1.green,map2.green band3=map1.blue,map2.blue classes=buildings,lakes model=/home/user/Documents/logs/mask_rcnn_buildings_lakes_0100.h5
```

External files, the georeferencing is internal (GeoTIFF):

```sh
i.ann.maskrcnn.detect images_directory=/home/user/Documents/georeferenced_images classes=buildings,lakes model=/home/user/Documents/logs/mask_rcnn_buildings_lakes_0100.h5 images_format=tif
```

External files, the georeferencing is external:

```sh
i.ann.maskrcnn.detect images_directory=/home/user/Documents/georeferenced_images classes=buildings,lakes model=/home/user/Documents/logs/mask_rcnn_buildings_lakes_0100.h5 images_format=png -e
```

### Detect cottages and plattenbaus and import them as points

```sh
i.ann.maskrcnn.detect band1=map1.red band2=map1.green band3=map1.blue classes=buildings,lakes model=/home/user/Documents/logs/mask_rcnn_buildings_lakes_0100.h5 output_type=point
```

## SEE ALSO

*[Mask R-CNN in GRASS GIS](i.ann.maskrcnn.md),
[i.ann.maskrcnn.train](i.ann.maskrcnn.train.md)*

## AUTHOR

Ondrej Pesek

## SOURCE CODE

Available at: [i.ann.maskrcnn.detect source code](https://github.com/OSGeo/grass-addons/tree/grass8/imagery/i.ann.maskrcnn/i.ann.maskrcnn.detect)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/imagery/i.ann.maskrcnn/i.ann.maskrcnn.detect))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
