---
name: i.eb.eta
description: Actual evapotranspiration for diurnal period (Bastiaanssen, 1995).
keywords: [ imagery, energy balance, actual evapotranspiration, SEBAL ]
---

# i.eb.eta

Actual evapotranspiration for diurnal period (Bastiaanssen, 1995).

=== "Command line"

    **i.eb.eta**
    **netradiationdiurnal**=*name*
    **evaporativefraction**=*name*
    **temperature**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.eb.eta netradiationdiurnal=rnetday evaporativefraction=evapfr temperature=tempk output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.eb.eta***",
        **netradiationdiurnal**=*"rnetday"*,
        **evaporativefraction**=*"evapfr"*,
        **temperature**=*"tempk"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.eb.eta", netradiationdiurnal="rnetday", evaporativefraction="evapfr", temperature="tempk", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_eb_eta*(**netradiationdiurnal**=*"rnetday"*,
        **evaporativefraction**=*"evapfr"*,
        **temperature**=*"tempk"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_eb_eta(netradiationdiurnal="rnetday", evaporativefraction="evapfr", temperature="tempk", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **netradiationdiurnal**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the diurnal net radiation map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rnetday*  
    **evaporativefraction**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the evaporative fraction map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *evapfr*  
    **temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the surface skin temperature [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tempk*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output actual evapotranspiration layer [mm/d]  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **netradiationdiurnal** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the diurnal net radiation map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rnetday*  
    **evaporativefraction** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the evaporative fraction map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *evapfr*  
    **temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the surface skin temperature [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tempk*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output actual evapotranspiration layer [mm/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **netradiationdiurnal** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the diurnal net radiation map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rnetday*  
    **evaporativefraction** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the evaporative fraction map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *evapfr*  
    **temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the surface skin temperature [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tempk*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output actual evapotranspiration layer [mm/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.eb.eta* calculates the actual evapotranspiration (ETa ; mm/d) for
diurnal period after \[1\], implemented in \[3\]. It takes input of
Diurnal Net Radiation (see *r.sun*), evaporative fraction (see
*i.eb.evapfr*) and surface skin temperature.

## NOTES

Full ETa processing will need those:

- *i.vi*, *i.albedo*, *r.latlong*, *i.emissivity*
- *i.evapo.potrad* (GRASS Addon)
- *i.eb.netrad*, *i.eb.soilheatflux*, *i.eb.hsebal01*
- *i.eb.evapfr*, *i.eb.eta*

(for time integration: *i.evapo.time_integration*)

For more details on the algorithms see \[1\]\[2\]\[3\]\[4\].

## REFERENCES

\[1\] Bastiaanssen, W.G.M., 1995. Estimation of Land surface parameters
by remote sensing under clear-sky conditions. PhD thesis, Wageningen
University, Wageningen, The Netherlands.
([PDF](https://edepot.wur.nl/206553))

\[2\] Chemin Y., Alexandridis T.A., 2001. Improving spatial resolution
of ET seasonal for irrigated rice in Zhanghe, China. Asian Journal of
Geoinformatics. 5(1):3-11,2004.

\[3\] Alexandridis T.K., Cherif I., Chemin Y., Silleos N.G., Stavrinos
E., Zalidis G.C. Integrated methodology for estimating water use in
Mediterranean agricultural areas. Remote Sensing. 2009, 1, 445-465.
([PDF](https://doi.org/10.3390/rs1030445))

\[4\] Chemin, Y., 2012. A Distributed Benchmarking Framework for Actual
ET Models, in: Irmak, A. (Ed.), Evapotranspiration - Remote Sensing and
Modeling. InTech. ([PDF](https://www.intechopen.com/chapters/26115))

## SEE ALSO

*[r.sun](r.sun.md), [i.eb.evapfr](i.eb.evapfr.md),
[i.eb.netrad](i.eb.netrad.md)*

## AUTHOR

Yann Chemin, Asian Institute of Technology, Thailand

## SOURCE CODE

Available at: [i.eb.eta source code](https://github.com/OSGeo/grass/tree/main/imagery/i.eb.eta)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.eb.eta))  
Latest change: Thursday Jun 26 21:25:27 2025 in commit [3ec2b13](https://github.com/OSGeo/grass/commit/3ec2b13945d963db69544e3fc9339fbff72f33f3)
