---
name: i.evapo.pm
description: Computes potential evapotranspiration calculation with hourly Penman-Monteith.
keywords: [ imagery, evapotranspiration ]
---

# i.evapo.pm

Computes potential evapotranspiration calculation with hourly Penman-Monteith.

=== "Command line"

    **i.evapo.pm**
    [**-zn**]
    **elevation**=*name*
    **temperature**=*name*
    **relativehumidity**=*name*
    **windspeed**=*name*
    **netradiation**=*name*
    **cropheight**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.evapo.pm elevation=name temperature=name relativehumidity=name windspeed=name netradiation=name cropheight=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.evapo.pm***",
        **elevation**,
        **temperature**,
        **relativehumidity**,
        **windspeed**,
        **netradiation**,
        **cropheight**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.evapo.pm", elevation="name", temperature="name", relativehumidity="name", windspeed="name", netradiation="name", cropheight="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_evapo_pm*(**elevation**,
        **temperature**,
        **relativehumidity**,
        **windspeed**,
        **netradiation**,
        **cropheight**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_evapo_pm(elevation="name", temperature="name", relativehumidity="name", windspeed="name", netradiation="name", cropheight="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map [m a.s.l.]  
    **temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input temperature raster map [C]  
    **relativehumidity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input relative humidity raster map [%]  
    **windspeed**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input wind speed raster map [m/s]  
    **netradiation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input net solar radiation raster map [MJ/m2/h]  
    **cropheight**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input crop height raster map [m]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map [mm/h]  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set negative evapotranspiration to zero  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use Night-time  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map [m a.s.l.]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input temperature raster map [C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **relativehumidity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input relative humidity raster map [%]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **windspeed** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input wind speed raster map [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **netradiation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input net solar radiation raster map [MJ/m2/h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cropheight** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input crop height raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map [mm/h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set negative evapotranspiration to zero  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use Night-time  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map [m a.s.l.]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input temperature raster map [C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **relativehumidity** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input relative humidity raster map [%]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **windspeed** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input wind speed raster map [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **netradiation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input net solar radiation raster map [MJ/m2/h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cropheight** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input crop height raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map [mm/h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set negative evapotranspiration to zero  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use Night-time  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.evapo.pm*, given the vegetation height (hc), humidity (RU), wind
speed at two meters height (WS), temperature (T), digital terrain model
(DEM), and net radiation (NSR) raster input maps, calculates the
potential evapotranspiration map (EPo).

Optionally the user can activate a flag (-z) that allows him setting to
zero all of the negative evapotranspiration cells; in fact these
negative values motivated by the condensation of the air water vapour
content, are sometime undesired because they can produce computational
problems. The usage of the flag -n detect that the module is run in
night hours and the appropriate soil heat flux is calculated.

The algorithm implements well known approaches: the hourly
Penman-Monteith method as presented in Allen et al. (1998) for land
surfaces and the Penman method (Penman, 1948) for water surfaces.

Land and water surfaces are idenfyied by Vh:

- where Vh gt 0 vegetation is present and evapotranspiration is
  calculated;
- where Vh = 0 bare ground is present and evapotranspiration is
  calculated;
- where Vh lt 0 water surface is present and evaporation is calculated.

For more details on the algorithms see \[1,2,3\].

## NOTES

Net solar radiation map in MJ/(m2\*h) can be computed from the
combination of the r.sun , run in mode 1, and the *r.mapcalc* commands.

The sum of the three radiation components outputted by r.sun (beam,
diffuse, and reflected) multiplied by the Wh to Mj conversion factor
(0.0036) and optionally by a clear sky factor \[0-1\] allows the
generation of a map to be used as an NSR input for the *i.evapo.PM*
command.

Example:

```sh
r.sun -s elevin=dem aspin=aspect slopein=slope lin=2 albedo=alb_Mar \
      incidout=out beam_rad=beam diff_rad=diffuse refl_rad=reflected \
      day=73 time=13:00 dist=100;
r.mapcalc "NSR = 0.0036 * (beam + diffuse + reflected)"
```

## REFERENCES

\[1\] Cannata M., 2006. [GIS embedded approach for Free & Open Source
Hydrological
Modelling](http://istgis.ist.supsi.ch:8001/geomatica/index.php?id=1).
PhD thesis, Department of Geodesy and Geomatics, Polytechnic of Milan,
Italy.

\[2\] Allen, R.G., L.S. Pereira, D. Raes, and M. Smith. 1998. Crop
Evapotranspiration: Guidelines for computing crop water requirements.
Irrigation and Drainage Paper 56, Food and Agriculture Organization of
the United Nations, Rome, pp. 300

\[3\] Penman, H. L. 1948. Natural evaporation from open water, bare soil
and grass. Proc. Roy. Soc. London, A193, pp. 120-146.

## SEE ALSO

The [HydroFOSS](http://istgis.ist.supsi.ch:8001/geomatica/) project at
IST-SUPSI (Institute of Earth Sciences - University school of applied
science for the Southern Switzerland)  
*[i.evapo.mh](i.evapo.mh.md), [i.evapo.time](i.evapo.time.md),
[r.sun](r.sun.md), [r.mapcalc](r.mapcalc.md)*

## AUTHORS

Original version of program: The
[HydroFOSS](http://istgis.ist.supsi.ch:8001/geomatica/index.php?id=1)
project, 2006, IST-SUPSI.
(<http://istgis.ist.supsi.ch:8001/geomatica/index.php?id=1>) *Massimiliano
Cannata, Scuola Universitaria Professionale della Svizzera Italiana -
Istituto Scienze della Terra*  
*Maria A. Brovelli, Politecnico di Milano - Polo regionale di Como*

Contact: [Massimiliano Cannata](mailto:massimiliano.cannata@supsi.ch)

## SOURCE CODE

Available at: [i.evapo.pm source code](https://github.com/OSGeo/grass/tree/main/imagery/i.evapo.pm)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.evapo.pm))  
Latest change: Thursday Jun 26 21:25:27 2025 in commit [3ec2b13](https://github.com/OSGeo/grass/commit/3ec2b13945d963db69544e3fc9339fbff72f33f3)
