---
name: i.evapo.senay
description: Actual evapotranspiration, method after Senay (2007)
keywords: [ Actual ET, evapotranspiration, Senay ]
---

# i.evapo.senay

Actual evapotranspiration, method after Senay (2007)

=== "Command line"

    **i.evapo.senay**
    [**-edb**]
    **temperature**=*name*
    **albedo**=*name*
    **elevation**=*name*
    [**latitude**=*name*]
    [**dayofyear**=*name*]
    [**transmissivitysingleway**=*name*]
    [**waterdensity**=*float*]
    [**slope**=*name*]
    [**aspect**=*name*]
    [**atmosphericemissivity**=*float*]
    [**airtemperature**=*name*]
    [**surfaceemissivity**=*name*]
    **ndvi**=*name*
    [**diurnaletpotential**=*name*]
    **output**=*name*
    [**evapfr**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.evapo.senay temperature=name albedo=name elevation=name ndvi=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.evapo.senay***",
        **temperature**,
        **albedo**,
        **elevation**,
        **latitude**=*None*,
        **dayofyear**=*None*,
        **transmissivitysingleway**=*None*,
        **waterdensity**=*1005.0*,
        **slope**=*None*,
        **aspect**=*None*,
        **atmosphericemissivity**=*None*,
        **airtemperature**=*None*,
        **surfaceemissivity**=*None*,
        **ndvi**,
        **diurnaletpotential**=*None*,
        **output**,
        **evapfr**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.evapo.senay", temperature="name", albedo="name", elevation="name", ndvi="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_evapo_senay*(**temperature**,
        **albedo**,
        **elevation**,
        **latitude**=*None*,
        **dayofyear**=*None*,
        **transmissivitysingleway**=*None*,
        **waterdensity**=*1005.0*,
        **slope**=*None*,
        **aspect**=*None*,
        **atmosphericemissivity**=*None*,
        **airtemperature**=*None*,
        **surfaceemissivity**=*None*,
        **ndvi**,
        **diurnaletpotential**=*None*,
        **output**,
        **evapfr**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_evapo_senay(temperature="name", albedo="name", elevation="name", ndvi="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the temperature layer [Degree Kelvin]  
    **albedo**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [0.0-1.0]  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation layer [m]  
    **latitude**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the degree latitude layer [dd.ddd]  
    **dayofyear**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day of Year layer [0.0-366.0]  
    **transmissivitysingleway**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way transmissivity layer [0.0-1.0]  
    **waterdensity**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the density of fresh water ~[1000-1020]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1005.0*  
    **slope**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Slope layer ~[0-90]  
    **aspect**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Aspect layer ~[0-360]  
    **atmosphericemissivity**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the apparent atmospheric emissivity (Bandara, 1998 used 0.845 for Sri Lanka)  
    **airtemperature**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Air Temperature layer [Kelvin], use with -b  
    **surfaceemissivity**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Surface Emissivity layer [-], use with -b  
    **ndvi**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI layer [-]  
    **diurnaletpotential**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ET Potential layer [mm/day]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output Actual ET layer  
    **evapfr**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output evaporative fraction layer  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;ET Potential Map as input (By-Pass creation of one)  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope/Aspect correction  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Net Radiation Bandara (1998), generic Longwave calculation, need apparent atmospheric emissivity, Air temperature and surface emissivity inputs  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the temperature layer [Degree Kelvin]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation layer [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **latitude** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the degree latitude layer [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day of Year layer [0.0-366.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transmissivitysingleway** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way transmissivity layer [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **waterdensity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the density of fresh water ~[1000-1020]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1005.0*  
    **slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Slope layer ~[0-90]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Aspect layer ~[0-360]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **atmosphericemissivity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the apparent atmospheric emissivity (Bandara, 1998 used 0.845 for Sri Lanka)  
    **airtemperature** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Air Temperature layer [Kelvin], use with -b  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **surfaceemissivity** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Surface Emissivity layer [-], use with -b  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndvi** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI layer [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **diurnaletpotential** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ET Potential layer [mm/day]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output Actual ET layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **evapfr** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output evaporative fraction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *d*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ET Potential Map as input (By-Pass creation of one)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Slope/Aspect correction  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Net Radiation Bandara (1998), generic Longwave calculation, need apparent atmospheric emissivity, Air temperature and surface emissivity inputs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the temperature layer [Degree Kelvin]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation layer [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **latitude** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the degree latitude layer [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day of Year layer [0.0-366.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transmissivitysingleway** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way transmissivity layer [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **waterdensity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the density of fresh water ~[1000-1020]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1005.0*  
    **slope** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Slope layer ~[0-90]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Aspect layer ~[0-360]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **atmosphericemissivity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the apparent atmospheric emissivity (Bandara, 1998 used 0.845 for Sri Lanka)  
    **airtemperature** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Air Temperature layer [Kelvin], use with -b  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **surfaceemissivity** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Surface Emissivity layer [-], use with -b  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndvi** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI layer [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **diurnaletpotential** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ET Potential layer [mm/day]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output Actual ET layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **evapfr** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output evaporative fraction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *d*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ET Potential Map as input (By-Pass creation of one)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Slope/Aspect correction  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Net Radiation Bandara (1998), generic Longwave calculation, need apparent atmospheric emissivity, Air temperature and surface emissivity inputs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.evapo.senay* Calculates the diurnal actual evapotranspiration after
Senay (2007). This is converting all Net radiation from the diurnal
period into ET, then uses Senay equation for evaporative fraction.

It takes input maps of Albedo, surface skin temperature, latitude, day
of year, single-way transmissivity and takes input value of the density
of fresh water.

DEM is used for calculating min and max temperature for Senay equation.

The "-s" flag permits output map of evaporative fraction from Senay.

## NOTES

If you are trying to map irrigated crops, and you know there is at least
one crop pixel that is evapotranspiring at maximum (ETa=ETpot), then
read this.

*i.evapo.senay* is highly dependent on the wet pixel being the lowest
temperature in the crop pixels to work for non water stressed crops,
force it that way, even if it breaks non crop areas. I suggest you
reduce your region to the irrigation system boundaries, checking that it
includes a bit of dry area for the hot/dry pixel.

Since it is a direct relationship to LST, evaporative fraction can be
very sensitive to the kind of pixel sample you feed it with.

## TODO

## SEE ALSO

*[r.sun](https://grass.osgeo.org/grass-stable/manuals/r.sun.html),
[i.albedo](https://grass.osgeo.org/grass-stable/manuals/i.albedo.html),
[i.eb.eta](https://grass.osgeo.org/grass-stable/manuals/i.eb.eta.html),
[i.eb.evapfr](https://grass.osgeo.org/grass-stable/manuals/i.eb.evapfr.html),
[i.evapo.potrad](i.evapo.potrad.md)*

## REFERENCES

- Senay 2007

Chemin, Y., 2012. A Distributed Benchmarking Framework for Actual ET
Models, in: Irmak, A. (Ed.), Evapotranspiration - Remote Sensing and
Modeling. InTech.
([PDF](https://www.intechopen.com/books/evapotranspiration-remote-sensing-and-modeling/a-distributed-benchmarking-framework-for-actual-et-models),
[DOI: 10.5772/23571](https://doi.org/10.5772/23571))

## AUTHOR

Yann Chemin, International Rice Research Institute, The Philippines.

## SOURCE CODE

Available at: [i.evapo.senay source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.evapo.senay)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.evapo.senay))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
