---
name: i.landsat
description: Toolset for downloading and importing of Landsat products
---

# Toolset for downloading and importing of Landsat products

## DESCRIPTION

The *i.landsat* toolset consists of three modules:

- [i.landsat.download](i.landsat.download.md)  
    downloads Landsat TM, ETM and OLI data from
    [EarthExplorer](https://earthexplorer.usgs.gov/) using
    [landsatxplore](https://github.com/yannforget/landsatxplore) Python
    library
- [i.landsat.import](i.landsat.import.md)  
    imports Landsat data downloaded from EarthExplorer into GRASS GIS
    mapsets
- [i.landsat.qa](i.landsat.qa.md)  
    reclassifies Landsat QA band according to acceptable pixel quality
    as defined by the user

## REQUIREMENTS

- An [EarthExplorer](https://ers.cr.usgs.gov/register) account
- [landsatxplore library](https://github.com/yannforget/landsatxplore)
    (install with `pip install landsatxplore`)

## AUTHORS

[Veronica Andreo](https://veroandreo.gitlab.io/), CONICET, Argentina.  
Stefan Blumentrath, Norwegian Institute for Nature Research, Oslo
(Norway)

## SOURCE CODE

Available at: [i.landsat source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.landsat)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.landsat))  
Latest change: Thursday May 29 11:23:19 2025 in commit [701c59b](https://github.com/OSGeo/grass-addons/commit/701c59b932c6a12e06ba3a4135cab5955cd9047a)
