---
name: i.rgb.his
description: Transforms raster maps from RGB (Red-Green-Blue) color space to HIS (Hue-Intensity-Saturation) color space.
keywords: [ imagery, color transformation, RGB, HIS, IHS ]
---

# i.rgb.his

Transforms raster maps from RGB (Red-Green-Blue) color space to HIS (Hue-Intensity-Saturation) color space.

=== "Command line"

    **i.rgb.his**
    **red**=*name*
    **green**=*name*
    **blue**=*name*
    **hue**=*name*
    **intensity**=*name*
    **saturation**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.rgb.his red=name green=name blue=name hue=name intensity=name saturation=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.rgb.his***",
        **red**,
        **green**,
        **blue**,
        **hue**,
        **intensity**,
        **saturation**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.rgb.his", red="name", green="name", blue="name", hue="name", intensity="name", saturation="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_rgb_his*(**red**,
        **green**,
        **blue**,
        **hue**,
        **intensity**,
        **saturation**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_rgb_his(red="name", green="name", blue="name", hue="name", intensity="name", saturation="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **red**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (red)  
    **green**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (green)  
    **blue**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (blue)  
    **hue**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (hue)  
    **intensity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (intensity)  
    **saturation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (saturation)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **red** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (red)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (green)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **blue** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (blue)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **hue** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (hue)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **intensity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (intensity)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **saturation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (saturation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **red** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (red)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (green)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **blue** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (blue)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **hue** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (hue)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **intensity** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (intensity)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **saturation** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (saturation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.rgb.his* is an image processing program that processes three input
raster map layers as red, green, and blue components and produces three
output raster map layers representing the hue, intensity, and saturation
of the data. The output raster map layers are created by a standard
red-green-blue (RGB) to hue-intensity-saturation (HIS) color
transformation. Each output raster map layer is given a linear gray
scale color table. The current geographic region definition and mask
settings are respected.

## SEE ALSO

*[i.his.rgb](i.his.rgb.md)*

## AUTHOR

David Satnik, GIS Laboratory, Central Washington University,  
with acknowledgements to Ali Vali, Space Research Center, for the core
routine.

## SOURCE CODE

Available at: [i.rgb.his source code](https://github.com/OSGeo/grass/tree/main/imagery/i.rgb.his)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.rgb.his))  
Latest change: Saturday May 31 03:33:38 2025 in commit [1935794](https://github.com/OSGeo/grass/commit/193579448e84c26e98f04e97918b6c61d5a2adff)
