---
name: i.sentinel.coverage.py
description: Checks the area coverage of Sentinel-1 or Sentinel-2 scenes selected by filters.
keywords: [ imagery, satellite, Sentinel, geometry, spatial query, area ]
---

# i.sentinel.coverage.py

Checks the area coverage of Sentinel-1 or Sentinel-2 scenes selected by filters.

=== "Command line"

    **i.sentinel.coverage.py**
    **settings**=*name*
    **area**=*name*
    [**start**=*string*]
    [**end**=*string*]
    [**producttype**=*string*]
    [**clouds**=*integer*]
    [**minpercent**=*integer*]
    [**names**=*string* [,*string*,...]]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.sentinel.coverage.py settings=name area=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.sentinel.coverage.py***",
        **settings**,
        **area**,
        **start**=*None*,
        **end**=*None*,
        **producttype**=*"S2MSI2A"*,
        **clouds**=*None*,
        **minpercent**=*None*,
        **names**=*None*,
        **output**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.sentinel.coverage.py", settings="name", area="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_sentinel_coverage_py*(**settings**,
        **area**,
        **start**=*None*,
        **end**=*None*,
        **producttype**=*"S2MSI2A"*,
        **clouds**=*None*,
        **minpercent**=*None*,
        **names**=*None*,
        **output**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_sentinel_coverage_py(settings="name", area="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **settings**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **area**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Area input vector maps  
    **start**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date ('YYYY-MM-DD')  
    **end**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date ('YYYY-MM-DD')  
    **producttype**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel product type to filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *SLC, GRD, OCN, S2MSI1C, S2MSI2A, S2MSI2Ap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *S2MSI2A*  
    **clouds**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum cloud cover percentage for Sentinel scene  
    **minpercent**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal percentage of coverage for Sentinel scene; error otherwise  
    **names**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel-1 or Sentinel-2 names  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with a list of Sentinel-1 or Sentinel-2 scene names  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **settings** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **area** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Area input vector maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **start** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date ('YYYY-MM-DD')  
    **end** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date ('YYYY-MM-DD')  
    **producttype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel product type to filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *SLC, GRD, OCN, S2MSI1C, S2MSI2A, S2MSI2Ap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *S2MSI2A*  
    **clouds** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum cloud cover percentage for Sentinel scene  
    **minpercent** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal percentage of coverage for Sentinel scene; error otherwise  
    **names** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel-1 or Sentinel-2 names  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with a list of Sentinel-1 or Sentinel-2 scene names  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **settings** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **area** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Area input vector maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **start** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date ('YYYY-MM-DD')  
    **end** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date ('YYYY-MM-DD')  
    **producttype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel product type to filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *SLC, GRD, OCN, S2MSI1C, S2MSI2A, S2MSI2Ap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *S2MSI2A*  
    **clouds** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum cloud cover percentage for Sentinel scene  
    **minpercent** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal percentage of coverage for Sentinel scene; error otherwise  
    **names** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel-1 or Sentinel-2 names  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with a list of Sentinel-1 or Sentinel-2 scene names  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.sentinel.coverage* is a GRASS GIS addon Python script to check the
area coverage by Sentinel scenes selected by a filter.

The coverage test considers only the geometric coverage by Sentinel
scene footprints and does not include the cloud covered pixels.

## EXAMPLES

### Check Sentinel-1 scenes by region, start and end time

Note that only the last 12 months of Sentinel data are online available
ESA Hub, older scenes are stored in the Long Term Archive (LTA) and
cannot be retrieved immediately. The example is based on the North
Carolina dataset:

```sh
# extract Durham (NC) county
v.extract input=boundary_county output=county_durham where="NAME = 'DURHAM'"

# simplify geometry (needed for ESA Hub)
v.generalize input=county_durham output=county_durham_dp1000 method=douglas threshold=1000

# search for SLC scenes in certain period of time
i.sentinel.coverage settings=credentials.txt output=s1names.txt \
  producttype=SLC minpercent=95 area=county_durham_dp1000 start=2020-10-01 end=2021-01-31
```

### Check Sentinel-2 scenes by region, cloud coverage, start and end time

Note that only the last 12 months of Sentinel data are online available
ESA Hub, older scenes are stored in the Long Term Archive (LTA) and
cannot be retrieved immediately. The example is based on the North
Carolina dataset:

```sh
# extract Durham (NC) county
v.extract input=boundary_county output=county_durham where="NAME = 'DURHAM'"

# simplify geometry (needed for ESA Hub)
v.generalize input=county_durham output=county_durham_dp1000 method=douglas threshold=1000

# search for L2A scenes with minimal clouds in certain period of time
i.sentinel.coverage settings=credentials.txt output=s2names.txt \
  producttype=S2MSI2A clouds=10 minpercent=95 area=county_durham_dp1000 start=2020-10-01 end=2021-01-31
```

### Check Sentinel-2 scenes by names

```sh
i.sentinel.coverage settings=credentials.txt output=s2names.txt \
  names=S2A_MSIL2A_20200104T024111_N0213_R089_T49MGU_20200104T061337,S2B_MSIL2A_20200129T023939_N0213_R089_T49MGU_20200201T153252 \
  producttype=S2MSI2A clouds=20 minpercent=95 area=mangkawuk
```

### Use retrieved Sentinel-2 scene names for import

When storing the list of scenes into a file, this resulting file can be
used for a parallelized import, using the
[t.sentinel](https://github.com/mundialis/t.sentinel) set of addons:

```sh
# install t.sentinel.import and related addons
g.extension extension=t.sentinel url=https://github.com/mundialis/t.sentinel

# download and import into space-time cube (STRDS), using 4 CPUs
t.sentinel.import settings=credentials.txt s2names=s2names.txt nprocs=4 \
  pattern='B(02_10|03_10|04_10|08_10)m' strds_output=s2_myarea directory=s2_data/
```

## SEE ALSO

*[i.sentinel.download](i.sentinel.download.md),
[v.dissolve](v.dissolve.md), [v.overlay](v.overlay.md),
[v.to.db](v.to.db.md)*

## AUTHOR

Anika Weinmann, [mundialis](https://www.mundialis.de/)

## SOURCE CODE

Available at: [i.sentinel.coverage source code](https://github.com/OSGeo/grass-addons/tree/grass8/imagery/i.sentinel/i.sentinel.coverage)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/imagery/i.sentinel/i.sentinel.coverage))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
