---
name: m.nviz.script
description: Creates fly-through script to run in NVIZ.
keywords: [ miscellaneous, graphics, raster, raster3d, vector, visualization ]
---

# m.nviz.script

Creates fly-through script to run in NVIZ.

=== "Command line"

    **m.nviz.script**
    [**-fckoe**]
    **input**=*name*
    **output**=*name*
    [**name**=*string*]
    [**route**=*east,north* [,*east,north*,...]]
    **dist**=*float*
    **ht**=*float*
    **frames**=*integer*
    [**start**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    m.nviz.script input=name output=name dist=0.0 ht=0.0 frames=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***m.nviz.script***",
        **input**,
        **output**,
        **name**=*None*,
        **route**=*None*,
        **dist**,
        **ht**,
        **frames**,
        **start**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("m.nviz.script", input="name", output="name", dist=0.0, ht=0.0, frames=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.m_nviz_script*(**input**,
        **output**,
        **name**=*None*,
        **route**=*None*,
        **dist**,
        **ht**,
        **frames**,
        **start**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.m_nviz_script(input="name", output="name", dist=0.0, ht=0.0, frames=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output script  
    **name**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix of output images (default = NVIZ)  
    **route**=*east,north* [,*east,north*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Route coordinates (east,north)  
    **dist**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Camera layback distance (in map units)  
    **ht**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Camera height above terrain  
    **frames**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of frames  
    **start**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start frame number (default=0)  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Full render -- Save images  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Fly at constant elevation (ht)  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include command in the script to output a KeyFrame file  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Render images off-screen  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Enable vector and sites drawing  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output script  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix of output images (default = NVIZ)  
    **route** : list[tuple[str, str]] | tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Route coordinates (east,north)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *east,north*  
    **dist** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Camera layback distance (in map units)  
    **ht** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Camera height above terrain  
    **frames** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of frames  
    **start** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start frame number (default=0)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *c*, *k*, *o*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Full render -- Save images  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fly at constant elevation (ht)  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include command in the script to output a KeyFrame file  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Render images off-screen  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Enable vector and sites drawing  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output script  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix of output images (default = NVIZ)  
    **route** : list[tuple[str, str]] | tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Route coordinates (east,north)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *east,north*  
    **dist** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Camera layback distance (in map units)  
    **ht** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Camera height above terrain  
    **frames** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of frames  
    **start** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start frame number (default=0)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *c*, *k*, *o*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Full render -- Save images  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fly at constant elevation (ht)  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include command in the script to output a KeyFrame file  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Render images off-screen  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Enable vector and sites drawing  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *m.nviz.script* program allows the user to easily create a script
that can be run in NVIZ to fly through a terrain. The NVIZ flight path
can be supplied on the command line as comma separated coordinates. The
program optionally allows a KeyFrame file to created (after running the
script). This KeyFrame file can be loaded into the *Keyframe Animation*
panel for fine tuning or editing.

The script generated by *m.nviz.script* can be run from the NVIZ command
line (nviz script=script_name) or after NVIZ is started by selecting
*Scripting-\>Play Script*.

## OPTIONS

### Flags

**-f**  
Full render

The script will draw all loaded NVIZ data and save scene to PPM image.

**-c**  
Flay at constant elevation

With this flag the camera will be set to an elevation given by the *ht=*
parameter. The default is to fly at *ht=* above the topography (i.e.
camera height = elevation + ht)

**-k**  
Output KeyFrame file

Generate a KeyFrame file that can be loaded from the NVIZ *Keyframe
Animation* panel. The KeyFrame file is automatically assigned the script
name with a *.kanimator* extension.

**-o**  
Render the animation in an off-screen context

**-e**  
Enable vector and sites drawing

### Parameters

**input**  
The name of the GRASS raster map with elevation data.

This should be the same file that will be loaded in NVIZ.

**output**  
The name of the NVIZ script to create.

**name**  
The prefix for output images if running in full render mode (*-f*).

The defulat preifix is NVIZ (eg. NVIZ0000.ppm).

**dist**  
The distance of the camera behind the center of view.

**ht**  
The height of the camera above the center of view.

If the the *-c* flag is set, the height represents the actual camera
height.

**frames**  
The number of frames in the animation.

**start**  
The starting frame number (default = 0).

This option may be useful in full render mode when creating an animation
in sections. For example the user may wish to start at frame number
2000.

**route**  
The comma separated geographic coordinates for keyframe locations.

## EXAMPLE

To interactively create an NVIZ animation from raster elev.rast with 500
frames and the camera set to 50 meters above and 250 meters behind the
scene, run the following:

```sh
g.region raster=elevation.dem
d.rast elevation.dem
m.nviz.script -k input=elevation.dem output=nviz.script dist=2400 ht=1220 frames=1000
```

In the above the example the user is prompted to select the route from
the GRASS monitor. The output script, 'nviz.script.nvscr', can then be
run in NVIZ:

```sh
nviz elevation=elevation.dem script=nviz.script.nvscr
```

## NOTES / HINTS

The user must select at least four key-frame locations (points)
otherwise an error is generated.

If the GRASS region is changed the *m.nviz.script* command must be
re-run.

The current GRASS region and the user supplied parameters are included
as a comment at the top of the output script. This information can be
used to easily re-create the animation.

The camera position is calculated backwards from the supplied
position(s). It is possible that the camera position will lie outside
the current window, in which case a non-fatal error is generated (Error:
selected point is outside region). This error can result in jerky
movements during the animation. To correct this problem reduce the
*dist=* parameter or increase the current region.

### Loading the script into NVIZ

The user can run the script at arbitrary resolution. To re-run it at
higher spatial resolution or different settings, the user first loads
the surface and sets the resolution, lighting, etc. Then internally the
script generated by *m.nviz.script* is run. Alternatively, the user can
run nviz with a previuosly saved state and the *m.nviz.script* generated
script:

```sh
nviz state=saved.state script=nviz.script.nvscr
```

### Keyframe animator script

Running the script generated by *m.nviz.script* within NVIZ, a new
script for kanimator (keyframe animator) is created. The kanimator panel
offers fine tuning of the speed (frame rate) as well as editing
individual frames or inserting new frames. This new kanimator script has
to be loaded from the Kanimator panel in NVIZ. In the Kanimator panel
there are Save and Load button which allow the user to save and re-load
a kanimator script. Once loaded, the key frames will appear in the GUI
and can then be edited there.

## SEE ALSO

*[wxGUI 3D viewer (NVIZ)](wxGUI.nviz.md)*

## AUTHOR

[Bob Covill](mailto:bcovill@tekmap.ns.ca)

## SOURCE CODE

Available at: [m.nviz.script source code](https://github.com/OSGeo/grass/tree/main/misc/m.nviz.script)
([history](https://github.com/OSGeo/grass/commits/main/misc/m.nviz.script))  
Latest change: Wednesday May 07 21:59:43 2025 in commit [30445c9](https://github.com/OSGeo/grass/commit/30445c936b13039b9eb55ae2c3a8bc4be285ec3b)
