---
name: m.prism.download.py
description: Downloads data from the PRISM Climate Group.
keywords: [ PRISM, Climate data ]
---

# m.prism.download.py

Downloads data from the PRISM Climate Group.

=== "Command line"

    **m.prism.download.py**
    [**-duf**]
    [**dataset**=*string* [,*string*,...]]
    [**start_date**=*string*]
    [**end_date**=*string*]
    [**separator**=*character*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    m.prism.download.py dataset=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***m.prism.download.py***",
        **dataset**=*None*,
        **start_date**=*None*,
        **end_date**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("m.prism.download.py", dataset="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.m_prism_download_py*(**dataset**=*None*,
        **start_date**=*None*,
        **end_date**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.m_prism_download_py(dataset="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **dataset**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Dataset index or ID  
    **start_date**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date for search in YYYY-MM-DD (today for today; first for first date of first data year)  
    **end_date**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date for search in YYYY-MM-DD (today for today; first for last date of first data year)  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;List supported datasets and exit  
  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;List URLs only without downloading  
  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;List filenames only without downloading  
  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **dataset** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dataset index or ID  
    **start_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date for search in YYYY-MM-DD (today for today; first for first date of first data year)  
    **end_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date for search in YYYY-MM-DD (today for today; first for last date of first data year)  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *u*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported datasets and exit  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List URLs only without downloading  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List filenames only without downloading  
  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **dataset** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dataset index or ID  
    **start_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date for search in YYYY-MM-DD (today for today; first for first date of first data year)  
    **end_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date for search in YYYY-MM-DD (today for today; first for last date of first data year)  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *u*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported datasets and exit  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List URLs only without downloading  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List filenames only without downloading  
  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*m.prism.download* downloads data from [the PRISM Climate
Group](https://prism.oregonstate.edu/).

## NOTES

This module anonymously logs in to [their FTP
server](ftp://ftp.prism.oregonstate.edu/) ([HTTPS
server](https://ftp.prism.oregonstate.edu/) for easier browsing) and
download climate data for a specified time period.

## EXAMPLES

List supported datasets and exit:

```sh
# use indices or datasets, but indices can change between module versions
m.prism.download -d
```

Download daily precipitation from 2020-01-01 to today:

```sh
# find the dataset name
m.prism.download -d | grep "daily" # found daily/ppt

# just list URLs for now
m.prism.download dataset=daily/ppt start_date=2020-01-01 end_date=today -u sep=newline

# actually download files
m.prism.download dataset=daily/ppt start_date=2020-01-01 end_date=today

# do something with the downloaded files
for file in $(m.prism.download dataset=daily/ppt start_date=2020-01-01 end_date=today -f sep=newline); do
    echo $file
    unzip $file
    # more tasks...
done
```

## SEE ALSO

*[m.cdo.download](m.cdo.download.md),
[m.tnm.download](m.tnm.download.md)*

## AUTHOR

[Huidae Cho](mailto:grass4u@gmail-com), New Mexico State University

## SOURCE CODE

Available at: [m.prism.download source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/misc/m.prism.download)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/misc/m.prism.download))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
