---
name: r.area
description: Calculates area of clumped areas and remove areas smaller or greater than given threshold.
keywords: [ raster, statistics, area ]
---

# r.area

Calculates area of clumped areas and remove areas smaller or greater than given threshold.

=== "Command line"

    **r.area**
    [**-b**]
    **input**=*name*
    **output**=*name*
    [**lesser**=*integer*]
    [**greater**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.area input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.area***",
        **input**,
        **output**,
        **lesser**=*0*,
        **greater**=*-1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.area", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_area*(**input**,
        **output**,
        **lesser**=*0*,
        **greater**=*-1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_area(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cell category map, e.g., maps created with r.clump  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster with categories representing area size (in cells)  
    **lesser**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove areas with number of cells lower than given value (0 for none):  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **greater**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove areas with number of cells greater than given value (-1 for none):  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Binary output  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cell category map, e.g., maps created with r.clump  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster with categories representing area size (in cells)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **lesser** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove areas with number of cells lower than given value (0 for none):  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **greater** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove areas with number of cells greater than given value (-1 for none):  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Binary output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cell category map, e.g., maps created with r.clump  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster with categories representing area size (in cells)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **lesser** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove areas with number of cells lower than given value (0 for none):  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **greater** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove areas with number of cells greater than given value (-1 for none):  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Binary output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module r.area reclassifies raster areas (created typically with
[r.clump](https://grass.osgeo.org/grass-stable/manuals/r.clump.html)) to
values representing their size (in cells). Additionally, it can be used
to remove areas smaller or greater than a threshold.

## NOTE

If areas belonging to a certain category are not continuous every area
belonging to the same category has the same area value.

## SEE ALSO

*[r.clump](https://grass.osgeo.org/grass-stable/manuals/r.clump.html),
[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.reclass.area](https://grass.osgeo.org/grass-stable/manuals/r.reclass.area.html)*

## AUTHOR

Jarek Jasiewicz

## SOURCE CODE

Available at: [r.area source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.area)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.area))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
