---
name: r.colors.contrastbrightness
description: Change the contrast/brightness of a raster.
keywords: [ raster, imagery, contrast, brightness ]
---

# r.colors.contrastbrightness

Change the contrast/brightness of a raster.

=== "Command line"

    **r.colors.contrastbrightness**
    **input**=*name*
    **output**=*name*
    **minimum**=*value*
    **maximum**=*value*
    **contrast**=*value*
    **brightness**=*value*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.colors.contrastbrightness input=name output=name minimum=0.0 maximum=0.0 contrast=1.0 brightness=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.colors.contrastbrightness***",
        **input**,
        **output**,
        **minimum**,
        **maximum**,
        **contrast**=*1.0*,
        **brightness**=*0.0*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.colors.contrastbrightness", input="name", output="name", minimum=0.0, maximum=0.0, contrast=1.0, brightness=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_colors_contrastbrightness*(**input**,
        **output**,
        **minimum**,
        **maximum**,
        **contrast**=*1.0*,
        **brightness**=*0.0*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_colors_contrastbrightness(input="name", output="name", minimum=0.0, maximum=0.0, contrast=1.0, brightness=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to change the contrast of.  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **minimum**=*value* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum input/output data value  
    **maximum**=*value* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum input/output data value  
    **contrast**=*value* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Contrast (gain, 8bit=&gt;[1.0-3.0]   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **brightness**=*value* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness (bias, 8bit=&gt;[0.0-100.0])  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to change the contrast of.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **minimum** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum input/output data value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **maximum** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum input/output data value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **contrast** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Contrast (gain, 8bit=&gt;[1.0-3.0]   
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **brightness** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness (bias, 8bit=&gt;[0.0-100.0])  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to change the contrast of.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **minimum** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum input/output data value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **maximum** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum input/output data value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **contrast** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Contrast (gain, 8bit=&gt;[1.0-3.0]   
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **brightness** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness (bias, 8bit=&gt;[0.0-100.0])  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.colors.contrastbrightness* module generates a contrasted version
of the input raster map. The contrast is the gain of the affine
transform, use values of 1.0-3.0 in case of an 8 bit image. The
brightness is the bias of the affine transform, use values of 0.0-100.0
in case of an 8 bit image.

## EXAMPLES

Contrast enhancement of an 8-bit raster band This does nothing to the
image:

```sh
r.colors.contrastbrightness min=0.0 max=255.0 contrast=1.0 brightness=0.0 input=myinraster output=myoutraster
```

This does change the contrast of the image:

```sh
r.colors.contrastbrightness min=0.0 max=255.0 contrast=3.0 brightness=0.0 input=myinraster output=myoutraster
```

This does change the brightness of the image:

```sh
r.colors.contrastbrightness min=0.0 max=255.0 contrast=1.0 brightness=100.0 input=myinraster output=myoutraster
```

## SEE ALSO

*[r.colors](https://grass.osgeo.org/grass-stable/manuals/r.colors.html),
[v.colors](https://grass.osgeo.org/grass-stable/manuals/v.colors.html),
[r3.colors](https://grass.osgeo.org/grass-stable/manuals/r3.colors.html),
[r.cpt2grass](r.cpt2grass.md),
[r.colors.matplotlib](r.colors.matplotlib.md)*

## AUTHOR

Yann Chemin, [JRC, Ispra, Italy](http://jrc.it/)

## SOURCE CODE

Available at: [r.colors.contrastbrightness source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.colors.contrastbrightness)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.colors.contrastbrightness))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
