---
name: r.composite
description: Combines red, green and blue raster maps into a single composite raster map.
keywords: [ raster, composite, RGB ]
---

# r.composite

Combines red, green and blue raster maps into a single composite raster map.

=== "Command line"

    **r.composite**
    [**-dc**]
    **red**=*name*
    **green**=*name*
    **blue**=*name*
    [**levels**=*integer*]
    [**level_red**=*integer*]
    [**level_green**=*integer*]
    [**level_blue**=*integer*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.composite red=name green=name blue=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.composite***",
        **red**,
        **green**,
        **blue**,
        **levels**=*32*,
        **level_red**=*None*,
        **level_green**=*None*,
        **level_blue**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.composite", red="name", green="name", blue="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_composite*(**red**,
        **green**,
        **blue**,
        **levels**=*32*,
        **level_red**=*None*,
        **level_green**=*None*,
        **level_blue**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_composite(red="name", green="name", blue="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **red**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    **green**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    **blue**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    **levels**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for each component  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **level_red**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **level_green**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **level_blue**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dither  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use closest color  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **red** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **blue** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **levels** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for each component  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **level_red** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **level_green** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **level_blue** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dither  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use closest color  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **red** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **blue** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **levels** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for each component  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **level_red** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **level_green** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **level_blue** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of levels to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dither  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use closest color  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This program combines three raster maps to form a composite RGB map. For
each input map layer, the corresponding component from the map's color
table is used (e.g. for the red map, the red component is used, and so
on). In general, the maps should use a grey-scale color table.

## NOTES

The default number of intensity levels for each component is 32,
resulting in a total of 32768 possible colors (equivalent to 15 bits per
pixel). If significantly more levels than this are used, not only will
*r.composite* take longer to run, but displaying the resulting layer
with *[d.rast](d.rast.md)* will also be significantly slower.

Floyd-Steinberg dithering is optionally used with the **-d** flag.

## EXAMPLES

### RGB composite of three satellite bands

Color composite of a LANDSAT scene (North Carolina sample dataset):

```sh
g.region raster=lsat7_2002_10
r.composite blue=lsat7_2002_10 green=lsat7_2002_20 red=lsat7_2002_30 \
            output=lsat7_2002_rgb
```

### RGB composite with dithering

Creating a composite RGB raster using 32 color levels per layer, with
dithering:

```sh
r.composite -d red=elevation.r green=elevation.g blue=elevation.b \
            output=elev.composite
```

## SEE ALSO

*[d.rast](d.rast.md), [d.rgb](d.rgb.md), [r.blend](r.blend.md),
[r.colors](r.colors.md), [r.rgb](r.rgb.md)*

*[Wikipedia Entry: Floyd-Steinberg
dithering](https://en.wikipedia.org/wiki/Floyd-Steinberg_dithering)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r.composite source code](https://github.com/OSGeo/grass/tree/main/raster/r.composite)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.composite))  
Latest change: Tuesday Jun 03 10:48:19 2025 in commit [9e40992](https://github.com/OSGeo/grass/commit/9e409925132a46abf5f445dc9b9cd9308cf215b1)
