---
name: r.cpt2grass.py
description: Convert or apply a GMT color table to a GRASS raster map
keywords: [  ]
---

# r.cpt2grass.py

Convert or apply a GMT color table to a GRASS raster map

=== "Command line"

    **r.cpt2grass.py**
    [**-s**]
    [**input**=*name*]
    [**url**=*string*]
    [**map**=*name*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.cpt2grass.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.cpt2grass.py***",
        **input**=*None*,
        **url**=*None*,
        **map**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.cpt2grass.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_cpt2grass_py*(**input**=*None*,
        **url**=*None*,
        **map**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_cpt2grass_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input GMT color table (.cpt file)  
    **url**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the color table  
    **map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to apply it to  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new rules file  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Stretch color scale to match map data extent  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input GMT color table (.cpt file)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **url** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the color table  
    **map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to apply it to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Stretch color scale to match map data extent  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input GMT color table (.cpt file)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **url** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the color table  
    **map** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to apply it to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Stretch color scale to match map data extent  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.cpt2grass* converts [GMT](http://gmt.soest.hawaii.edu/) color
palette (\*.cpt) format to GRASS color table format and assigns it to a
given raster map. Input can be either cpt file given in **input** option
or a URL of the cpt file specified in **url** option. Specifying URL is
particularly useful when using color tables from
[cpt-city](http://soliton.vm.bytemark.co.uk/pub/cpt-city/), because many
color tables can be quickly tested without downloading the files. When
option **map** is specified *r.cpt2grass* assigns the color rules to the
given raster map. Depending on the values of the original cpt file, it
may be advantageous to use the **-s** to stretch the colors based on the
range of values of the map.

## NOTES

RGB and HSV models are supported. The expected format of the cpt file
is:

```text
# COLOR_MODEL = RGB
value1 R G B value2 R G B
value2 R G B value3 R G B
...
```

Named colors are not supported.

## EXAMPLES

From [cpt-city](http://soliton.vm.bytemark.co.uk/pub/cpt-city/) we
download a
[rainfall](http://soliton.vm.bytemark.co.uk/pub/cpt-city/jjg/misc/rainfall.cpt)
color table and convert it to GRASS color table. If we don't specify
output file, it is printed to standard output:

```sh
r.cpt2grass input=rainfall.cpt
```

```text
0.000 229:180:44
20.000 229:180:44
20.000 242:180:100
40.000 242:180:100
40.000 243:233:119
60.000 243:233:119
60.000 145:206:126
80.000 145:206:126
80.000 67:190:135
100.000 67:190:135
100.000 52:180:133
120.000 52:180:133
120.000 6:155:66
140.000 6:155:66
```

We set two different elevation color tables - continuous and discrete
gradients. We have to stretch the color tables to fit the raster map
range:

```sh
r.cpt2grass url=http://soliton.vm.bytemark.co.uk/pub/cpt-city/td/DEM_screen.cpt map=elevation -s
r.cpt2grass url=http://soliton.vm.bytemark.co.uk/pub/cpt-city/cb/seq/YlOrBr_09.cpt map=elevation -s
```

We can display legend:

```sh
d.legend raster=elevation labelnum=10 at=5,50,7,10
```

![image-alt](r_cpt2grass_color_table_DEM_screen.png)
![image-alt](r_cpt2grass_color_table_YlOrBr_09.png)

## SEE ALSO

*[r.colors](https://grass.osgeo.org/grass-stable/manuals/r.colors.html)*

## AUTHORS

Anna Petrasova, [NCSU OSGeoREL](http://gis.ncsu.edu/osgeorel/)  
Hamish Bowman (original Bash script)

## SOURCE CODE

Available at: [r.cpt2grass source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.cpt2grass)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.cpt2grass))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
