---
name: r.fusion.py
description: image fusion, generalized pan-sharpening
keywords: [ raster, imagery, fusion, sharpen ]
---

# r.fusion.py

image fusion, generalized pan-sharpening

=== "Command line"

    **r.fusion.py**
    [**-r**]
    **input**=*name*
    **highres**=*name*
    [**method**=*string*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.fusion.py input=name highres=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.fusion.py***",
        **input**,
        **highres**,
        **method**=*"difference"*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.fusion.py", input="name", highres="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_fusion_py*(**input**,
        **highres**,
        **method**=*"difference"*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_fusion_py(input="name", highres="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Low-resolution raster to be enhanced  
    **highres**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;High-resolution raster with spatial detail  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solution method: Finite Diff. or Superpos. of analytical sol'ns  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *difference, proportion*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *difference*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Restrict output value range to input value range  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended for imagery with a defined valid value range, e.g. [0, 255]  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low-resolution raster to be enhanced  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **highres** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;High-resolution raster with spatial detail  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solution method: Finite Diff. or Superpos. of analytical sol'ns  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *difference, proportion*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *difference*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restrict output value range to input value range  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recommended for imagery with a defined valid value range, e.g. [0, 255]  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low-resolution raster to be enhanced  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **highres** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;High-resolution raster with spatial detail  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solution method: Finite Diff. or Superpos. of analytical sol'ns  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *difference, proportion*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *difference*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restrict output value range to input value range  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recommended for imagery with a defined valid value range, e.g. [0, 255]  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.fusion* enhances the resolution of a raster map by using spatial
detail of a high-resolution map. The actual values in the resultant
output map correspond to the input map while the spatial detail
corresponds to the high-resolution map. The effect is similar to
pan-sharpening, but the method can be applied more generally, not only
to imagery but also to climatological data such as temperature or
precipitation.

## NOTES

Two different methods are available with the **method** option:
*difference* and *proportion*.

The *difference* method uses the formula

A - B + B = A

more specifically

highres(A<sub>lowres</sub> - B<sub>lowres</sub>) + B<sub>highres</sub> =
A<sub>highres</sub>

where *highres()* is a function to interpolate the differences. Here,
*r.resamp.filter* is used for interpolation.

The *proportion* method is suitable for e.g. precipitation where zero
precipition must stay zero precipition, and uses the formula

A / B \* B = A

more specifically

highres(A<sub>lowres</sub> / B<sub>lowres</sub>) \* B<sub>highres</sub>
= A<sub>highres</sub>

Again, *highres()* is a function to interpolate the proportions, and
*r.resamp.filter* is used for interpolation. For the *proportion*
method, all values in the high-resolution B map must be \> 0.

## SEE ALSO

*[r.resamp.filter](https://grass.osgeo.org/grass-stable/manuals/r.resamp.filter.html)*

## AUTHOR

Markus Metz, mundialis

## SOURCE CODE

Available at: [r.fusion source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.fusion)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.fusion))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
