---
name: r.futures.potsurface.py
description: Module for computing development potential surface from CSV file created by r.futures.potential and predictors
keywords: [ raster, statistics ]
---

# r.futures.potsurface.py

Module for computing development potential surface from CSV file created by r.futures.potential and predictors

=== "Command line"

    **r.futures.potsurface.py**
    **input**=*name*
    **subregions**=*name*
    **output**=*name*
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.futures.potsurface.py input=name subregions=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.futures.potsurface.py***",
        **input**,
        **subregions**,
        **output**,
        **separator**=*"comma"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.futures.potsurface.py", input="name", subregions="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_futures_potsurface_py*(**input**,
        **subregions**,
        **output**,
        **separator**=*"comma"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_futures_potsurface_py(input="name", subregions="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with coefficients  
    **subregions**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output probability raster  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input CSV file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with coefficients  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **subregions** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output probability raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input CSV file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with coefficients  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **subregions** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output probability raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input CSV file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.futures.potsurface* is a support tool for computing
development probability surface based on maps and coefficients selected
by *[r.futures.potential](r.futures.potential.md)*. It computes the
initial probability surface used in the patch growing algorithm in
*[r.futures.pga](r.futures.pga.md)*. It is not necessary to use this
module, however it is useful to inspect the potential surface to better
understand the input data and how the predictors influence the
probability. The values range from 0 (unlikely to be developed) to 1
(high probability of development).

The inputs are the output file from
*[r.futures.potential](r.futures.potential.md)* and the name of the
**subregions** raster map.

## EXAMPLES

```sh
r.futures.potsurface input=potential.csv subregions=counties output=pot_surface
```

![image-alt](r_futures_potsurface.png)

Figure: We can visualize the potential surface in 3D and drape raster
representing developed (red) and undeveloped (green) cells over it.

## SEE ALSO

[FUTURES](r.futures.md), *[r.futures.pga](r.futures.pga.md)*,
*[r.futures.potential](r.futures.potential.md)*,
*[r.futures.devpressure](r.futures.devpressure.md)*,
*[r.futures.demand](r.futures.demand.md)*,
*[r.futures.calib](r.futures.calib.md)*,
*[r.sample.category](r.sample.category.md)*

## REFERENCES

- Meentemeyer, R. K., Tang, W., Dorning, M. A., Vogler, J. B.,
    Cunniffe, N. J., & Shoemaker, D. A. (2013). [FUTURES: Multilevel
    Simulations of Emerging Urban-Rural Landscape Structure Using a
    Stochastic Patch-Growing
    Algorithm](https://doi.org/10.1080/00045608.2012.707591). Annals of
    the Association of American Geographers, 103(4), 785-807. DOI:
    10.1080/00045608.2012.707591
- Dorning, M. A., Koch, J., Shoemaker, D. A., & Meentemeyer, R. K.
    (2015). [Simulating urbanization scenarios reveals tradeoffs between
    conservation planning
    strategies](https://doi.org/10.1016/j.landurbplan.2014.11.011).
    Landscape and Urban Planning, 136, 28-39. DOI:
    10.1016/j.landurbplan.2014.11.011
- Petrasova, A., Petras, V., Van Berkel, D., Harmon, B. A., Mitasova,
    H., & Meentemeyer, R. K. (2016). [Open Source Approach to Urban
    Growth
    Simulation](https://isprs-archives.copernicus.org/articles/XLI-B7/953/2016/isprs-archives-XLI-B7-953-2016.pdf).
    Int. Arch. Photogramm. Remote Sens. Spatial Inf. Sci., XLI-B7,
    953-959. DOI: 10.5194/isprsarchives-XLI-B7-953-2016

## AUTHOR

Anna Petrasova, [NCSU GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.futures.potsurface source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.futures/r.futures.potsurface)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.futures/r.futures.potsurface))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
