---
name: r.green.biomassfor.legal.py
description: Estimates potential bioenergy depending on forest increment, forest management and forest treatment
keywords: [ raster, biomass ]
---

# r.green.biomassfor.legal.py

Estimates potential bioenergy depending on forest increment, forest management and forest treatment

=== "Command line"

    **r.green.biomassfor.legal.py**
    **forest**=*name*
    **boundaries**=*name*
    [**energy_tops_hf**=*float*]
    [**forest_column_yield**=*string*]
    [**forest_column_yield_surface**=*string*]
    [**forest_column_management**=*string*]
    [**forest_column_treatment**=*string*]
    [**output_basename**=*name*]
    [**energy_cormometric_vol_hf**=*float*]
    [**energy_tops_cop**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.biomassfor.legal.py forest=name boundaries=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.biomassfor.legal.py***",
        **forest**,
        **boundaries**,
        **energy_tops_hf**=*0.49*,
        **forest_column_yield**=*"yield"*,
        **forest_column_yield_surface**=*"yield_surface"*,
        **forest_column_management**=*"management"*,
        **forest_column_treatment**=*"treatment"*,
        **output_basename**=*"biomassfor"*,
        **energy_cormometric_vol_hf**=*1.97*,
        **energy_tops_cop**=*0.55*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.biomassfor.legal.py", forest="name", boundaries="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_biomassfor_legal_py*(**forest**,
        **boundaries**,
        **energy_tops_hf**=*0.49*,
        **forest_column_yield**=*"yield"*,
        **forest_column_yield_surface**=*"yield_surface"*,
        **forest_column_management**=*"management"*,
        **forest_column_treatment**=*"treatment"*,
        **output_basename**=*"biomassfor"*,
        **energy_cormometric_vol_hf**=*1.97*,
        **energy_tops_cop**=*0.55*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_biomassfor_legal_py(forest="name", boundaries="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **forest**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    **boundaries**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    **energy_tops_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **forest_column_yield**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yield*  
    **forest_column_yield_surface**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yield_surface*  
    **forest_column_management**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *management*  
    **forest_column_treatment**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *treatment*  
    **output_basename**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for potential bioenergy (HF,CC and total)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *biomassfor*  
    **energy_cormometric_vol_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for the whole tree in high forest (tops, branches and stem) in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **forest** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **boundaries** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **energy_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **forest_column_yield** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yield*  
    **forest_column_yield_surface** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yield_surface*  
    **forest_column_management** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *management*  
    **forest_column_treatment** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *treatment*  
    **output_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for potential bioenergy (HF,CC and total)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *biomassfor*  
    **energy_cormometric_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for the whole tree in high forest (tops, branches and stem) in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **forest** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **boundaries** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **energy_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **forest_column_yield** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yield*  
    **forest_column_yield_surface** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yield_surface*  
    **forest_column_management** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *management*  
    **forest_column_treatment** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *treatment*  
    **output_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for potential bioenergy (HF,CC and total)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *biomassfor*  
    **energy_cormometric_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for the whole tree in high forest (tops, branches and stem) in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Compute the legal biomass forestry residual potential, based on the
annual/periodic forest yield.

## NOTES

This module permits to evalute the maximum bio-energy from forest
residual available in a particular area, on the base of the prescribed
yield. The mandatory data input are a vector file with fields with
values of yield, management, treatment, and forest surface. The yield
value is expressed in cubic meters, the forest surface in hectares, the
management is an integer value that can be 1 for high forest and 2 for
coppice, the treatment is an integer field that can be 1 for final
felling and 2 for thinning. The energy section contains the calorific
parameters that permits to convert the biomass in energy. The output
maps are expressed in Mwh.

## EXAMPLE

This example shows a typical input vector file with a table composed by
fields of increment, forest surface, management and treatment. This
example is based on data of Maè Valley, one of the test area of the
R.green project  
  
![image-alt](legal_input.png)

|       |         |            |           |
| ----- | ------- | ---------- | --------- |
| yield | surface | management | treatment |
| 35.87 | 800     | 1          | 1         |
| 16.48 | 700     | 1          | 2         |
| 24.82 | 300     | 2          | 1         |

```sh
r.green.biomassfor.legal --overwrite forest=forest@biomasfor boundaries=Boundary@biomasfor forest_column_yield=yield forest_column_yield_surface=surface forest_column_management=management forest_column_treatment=treatment energy_tops_hs=0.49 energy_cormometric_vol_hf=1.97 energy_tops_cops=0.55 output_basename=mae
```

![image-alt](legal_output.png)

The output map is a standardize energy map with the pixel value equal to
the corresponding bioenergy stimated.

## REFERENCE

Sacchelli, S., Zambelli, P., Zatelli, P., Ciolli, M., 2013. Biomasfor -
an open-source holistic model for the assessment of sustainable forest
bioenergy. iFor. Biogeosci. For. 6, 285-293

## SEE ALSO

*[r.green.biomassfor.theoretical](r.green.biomassfor.theoretical.md),
[r.green.biomassfor.technical](r.green.biomassfor.technical.md)*

## AUTHORS

Francesco Geri, Pietro Zambelli, Sandro Sacchelli, Marco Ciolli

## SOURCE CODE

Available at: [r.green.biomassfor.legal source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.biomassfor/r.green.biomassfor.legal)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.biomassfor/r.green.biomassfor.legal))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
