---
name: r.in.nasadem.py
description: Creates a DEM from 1 arcsec NASADEM tiles.
keywords: [ raster, import, SRTM ]
---

# r.in.nasadem.py

Creates a DEM from 1 arcsec NASADEM tiles.

=== "Command line"

    **r.in.nasadem.py**
    [**-z**]
    [**version**=*string*]
    [**layer**=*string*]
    **output**=*name*
    [**username**=*string*]
    [**password**=*string*]
    [**url**=*string*]
    [**local**=*name*]
    [**region**=*xmin,ymin,xmax,ymax*]
    [**method**=*string*]
    [**resolution**=*float*]
    [**memory**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.nasadem.py output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.nasadem.py***",
        **version**=*"NASADEM_HGT.001"*,
        **layer**=*"hgt"*,
        **output**,
        **username**=*None*,
        **password**=*None*,
        **url**=*"https://e4ftl01.cr.usgs.gov/MEASURES"*,
        **local**=*None*,
        **region**=*None*,
        **method**=*"bilinear_f"*,
        **resolution**=*None*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.nasadem.py", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_nasadem_py*(**version**=*"NASADEM_HGT.001"*,
        **layer**=*"hgt"*,
        **output**,
        **username**=*None*,
        **password**=*None*,
        **url**=*"https://e4ftl01.cr.usgs.gov/MEASURES"*,
        **local**=*None*,
        **region**=*None*,
        **method**=*"bilinear_f"*,
        **resolution**=*None*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_nasadem_py(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **version**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;NASADEM version  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *NASADEM_HGT.001*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NASADEM_HGT.001*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;NASADEM layer to import  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *hgt, num, swb*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hgt*  
    &nbsp;&nbsp;&nbsp;&nbsp;**hgt**: Void-filled DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;**num**: Number of scenes  
    &nbsp;&nbsp;&nbsp;&nbsp;**swb**: Updated SRTM water body data  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **username**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for authentication  
    **password**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for authentication  
    **url**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL to fetch NASADEM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *https://e4ftl01.cr.usgs.gov/MEASURES*  
    **local**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Local folder with NASADEM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Use local folder instead of URL to retrieve NASADEM tiles  
    **region**=*xmin,ymin,xmax,ymax*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only (default is current region)  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bilinear_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **resolution**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (required if location projection not longlat)  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create zero elevation for missing tiles  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **version** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;NASADEM version  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *NASADEM_HGT.001*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NASADEM_HGT.001*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;NASADEM layer to import  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *hgt, num, swb*  
    &nbsp;&nbsp;&nbsp;&nbsp;**hgt**: Void-filled DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;**num**: Number of scenes  
    &nbsp;&nbsp;&nbsp;&nbsp;**swb**: Updated SRTM water body data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hgt*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **username** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for authentication  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for authentication  
    **url** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL to fetch NASADEM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *https://e4ftl01.cr.usgs.gov/MEASURES*  
    **local** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Local folder with NASADEM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Use local folder instead of URL to retrieve NASADEM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **region** : tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only (default is current region)  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *xmin,ymin,xmax,ymax*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bilinear_f*  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (required if location projection not longlat)  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create zero elevation for missing tiles  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **version** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;NASADEM version  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *NASADEM_HGT.001*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NASADEM_HGT.001*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;NASADEM layer to import  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *hgt, num, swb*  
    &nbsp;&nbsp;&nbsp;&nbsp;**hgt**: Void-filled DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;**num**: Number of scenes  
    &nbsp;&nbsp;&nbsp;&nbsp;**swb**: Updated SRTM water body data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hgt*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **username** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for authentication  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for authentication  
    **url** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL to fetch NASADEM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *https://e4ftl01.cr.usgs.gov/MEASURES*  
    **local** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Local folder with NASADEM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Use local folder instead of URL to retrieve NASADEM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **region** : tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only (default is current region)  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *xmin,ymin,xmax,ymax*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bilinear_f*  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (required if location projection not longlat)  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create zero elevation for missing tiles  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.nasadem* imports all NASADEM tiles covering the current region or
region extents given with the **region** option into GRASS and patches
the tiles together.

Cited from
<https://lpdaac.usgs.gov/news/release-nasadem-data-products/>:

"NASADEM extends the legacy of the Shuttle Radar Topography Mission
(SRTM) by improving the digital elevation model (DEM) height accuracy
and data coverage as well as providing additional SRTM radar-related
data products. The improvements were achieved by reprocessing the
original SRTM radar signal data and telemetry data with updated
algorithms and auxiliary data not available at the time of the original
SRTM processing."

In total, 14,520 NASADEM tiles are available.

*r.in.nasadem* imports data from
[NASADEM\_HGT.001](https://doi.org/10.5067/MEaSUREs/NASADEM/NASADEM_HGT.001),
or from a local copy of these data provided with the **local** option.

There are three different layers available in the
[NASADEM\_HGT.001](https://doi.org/10.5067/MEaSUREs/NASADEM/NASADEM_HGT.001)
product: *hgt*, *num*, and *swb*, each of these layers can be imported
with *r.in.nasadem* with the **layer** option. Importantly, for the
NASADEM tiles download a user registration is needed at
<https://urs.earthdata.nasa.gov/users/new>

In the earthdata user profile, two specific applications must be
approved in the "My application" tab:

- "LP DAAC Data Pool" application, and
- "Earthdata Search" application.

## EXAMPLE

Import of NASADEM\_HGT.001 covering the current computational region:

```sh
# run in LatLong location - Sicily East, Italy
g.region n=39 s=37 w=14 e=16 res=0:00:01 -p

# use own credentials here
r.in.nasadem user="my_nasa_user" password="my_nasa_pw" output=nasadem_sicily_1arc memory=2000
r.univar nasadem_sicily_1arc
```

[![image-alt](r_in_nasadem_etna.jpg)](r_in_nasadem_etna.jpg)  
*Figure: Eta volcano (Sicily, Italy) shown in NVIZ*

## SEE ALSO

*[r.in.srtm](https://grass.osgeo.org/grass-stable/manuals/r.in.srtm.html),
[r.in.srtm.region](r.in.srtm.region.md)*

The [Shuttle Radar Topography Mission](http://www2.jpl.nasa.gov/srtm/)
homepage at NASA's JPL (see also [MEaSUREs Data Product Table -
SRTM](https://lpdaac.usgs.gov/product_search/?collections=MEaSUREs+SRTM&status=Operational&view=list)).

The
[NASADEM\_HGT.001](https://doi.org/10.5067/MEaSUREs/NASADEM/NASADEM_HGT.001)
product page.

## REFERENCES

M. Neteler, 2005. [SRTM and VMAP0 data in OGR and
GRASS.](https://grass.osgeo.org/newsletter/GRASSNews_vol3.pdf) *[GRASS
Newsletter](https://grass.osgeo.org/newsletter/)*, Vol.3, pp. 2-6, June
2005. ISSN 1614-8746.

## AUTHORS

Markus Metz  
Reprojection support: Anika Bettge, mundialis

## SOURCE CODE

Available at: [r.in.nasadem source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.in.nasadem)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.in.nasadem))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
