---
name: r.in.srtm.region.py
description: Creates a DEM from 3 arcsec SRTM v2.1 or 1 arcsec SRTM v3 tiles.
keywords: [ raster, import, SRTM ]
---

# r.in.srtm.region.py

Creates a DEM from 3 arcsec SRTM v2.1 or 1 arcsec SRTM v3 tiles.

=== "Command line"

    **r.in.srtm.region.py**
    [**-n21z**]
    **output**=*name*
    **username**=*string*
    **password**=*string*
    [**url**=*string*]
    [**local**=*name*]
    [**region**=*xmin,ymin,xmax,ymax*]
    [**memory**=*integer*]
    [**method**=*string*]
    [**resolution**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.srtm.region.py output=name username=string password=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.srtm.region.py***",
        **output**,
        **username**,
        **password**,
        **url**=*None*,
        **local**=*None*,
        **region**=*None*,
        **memory**=*300*,
        **method**=*None*,
        **resolution**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.srtm.region.py", output="name", username="string", password="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_srtm_region_py*(**output**,
        **username**,
        **password**,
        **url**=*None*,
        **local**=*None*,
        **region**=*None*,
        **memory**=*300*,
        **method**=*None*,
        **resolution**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_srtm_region_py(output="name", username="string", password="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **username**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for authentication  
    **password**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for authentication  
    **url**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL to fetch SRTM tiles  
    **local**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Local folder with SRTM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Use local folder instead of URL to retrieve SRTM tiles  
    **region**=*xmin,ymin,xmax,ymax*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only (default is current region)  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB for interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **resolution**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (required if location projection not longlat)  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Fill null cells  
    **-2**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import SRTM v2 tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: Import SRTM v3 tiles  
    **-1**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input is a 1-arcsec tile (default: 3-arcsec)  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create zero elevation for missing tiles  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **username** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for authentication  
    **password** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for authentication  
    **url** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL to fetch SRTM tiles  
    **local** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Local folder with SRTM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Use local folder instead of URL to retrieve SRTM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **region** : tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only (default is current region)  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *xmin,ymin,xmax,ymax*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB for interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (required if location projection not longlat)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *2*, *1*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fill null cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import SRTM v2 tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Default: Import SRTM v3 tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;**1**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input is a 1-arcsec tile (default: 3-arcsec)  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create zero elevation for missing tiles  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **username** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for authentication  
    **password** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for authentication  
    **url** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL to fetch SRTM tiles  
    **local** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Local folder with SRTM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Use local folder instead of URL to retrieve SRTM tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **region** : tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only (default is current region)  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *xmin,ymin,xmax,ymax*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB for interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (required if location projection not longlat)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *2*, *1*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fill null cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import SRTM v2 tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Default: Import SRTM v3 tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;**1**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input is a 1-arcsec tile (default: 3-arcsec)  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create zero elevation for missing tiles  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.srtm.region* imports all SRTM tiles covering the current region or
region extents given with **region** into GRASS, patches the tiles
together and optionally interpolates holes for SRTM V2.1. The SRTM V003
products are already void-filled.

*r.in.srtm.region* downloads ([SRTM product
description](https://lpdaac.usgs.gov/documents/179/SRTM_User_Guide_V3.pdf))

- SRTMGL1 V003 tiles at 1 arc second (about 30 meters) resolution,
    void-filled from:  
    <https://e4ftl01.cr.usgs.gov/MEASURES/SRTMGL1.003/2000.02.11/>
- SRTMGL3 V003 tiles at 3 arc seconds (about 90 meters) resolution,
    void-filled from:  
    <https://e4ftl01.cr.usgs.gov/MEASURES/SRTMGL3.003/2000.02.11/>
- SRTM V2.1 tiles at 3 arc second (about 90 meters) resolution from:
    [http://dds.cr.usgs.gov/srtm/](http://dds.cr.usgs.gov/srtm/version2_1/SRTM3/)
- or, optionally *r.in.srtm.region* uses a local folder with
    previously downloaded SRTM data files if the **local** option is
    given.

Importantly, for the SRTM tiles download a user registration is needed
at <https://urs.earthdata.nasa.gov/users/new>

In the user profile, two specific applications must be approved in the
"My application" tab:

- "LP DAAC Data Pool" application, and
- "Earthdata Search" application.

## EXAMPLE

Import of SRTMGL1 V003 (1 arc seconds \~ 30m) covering the current
computational region:

```sh
# run in LatLong location - Sicily East, Italy
g.region n=39 s=37 w=14 e=16 res=0:00:01 -p

# use own credentials here
r.in.srtm.region -1 user="my_nasa_user" password="my_nasa_pw" output=srtm_sicily_1arc memory=2000
r.univar srtm_sicily_1arc
```

[![image-alt](r_in_srtm_region_etna.png)](r_in_srtm_region_etna.png)  
*Figure: Eta volcano (Sicily, Italy) shown in NVIZ*

## SEE ALSO

*[r.in.srtm](https://grass.osgeo.org/grass-stable/manuals/r.in.srtm.html),
[r.in.nasadem](r.in.nasadem.md) (addon)*

The [Shuttle Radar Topography Mission](http://www2.jpl.nasa.gov/srtm/)
homepage at NASA's JPL (see also [MEaSUREs Data Product Table -
SRTM](https://lpdaac.usgs.gov/product_search/?collections=MEaSUREs+SRTM&status=Operational&view=list)).

The [SRTM v3
documentation](https://lpdaac.usgs.gov/sites/default/files/public/measures/docs/NASA_SRTM_V3.pdf).

[SRTMGL1: NASA Shuttle Radar Topography Mission Global 1 arc second
V003](https://lpdaac.usgs.gov/products/srtmgl1v003/)

NASA JPL. (2013). *NASA Shuttle Radar Topography Mission Global 1 arc
second.* NASA LP DAAC.
<https://doi.org/10.5067/MEaSUREs/SRTM/SRTMGL1.003>

## REFERENCES

M. Neteler, 2005. [SRTM and VMAP0 data in OGR and
GRASS.](https://grass.osgeo.org/newsletter/GRASSNews_vol3.pdf) *[GRASS
Newsletter](https://grass.osgeo.org/newsletter/)*, Vol.3, pp. 2-6, June
2005. ISSN 1614-8746.

## AUTHORS

Markus Metz  
Reprojection support: Anika Bettge, mundialis

## SOURCE CODE

Available at: [r.in.srtm.region source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.in.srtm.region)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.in.srtm.region))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
