---
name: r.in.usgs.py
description: Download user-requested products through the USGS TNM API
keywords: [ import, raster, USGS, NED, NAIP, parallel ]
---

# r.in.usgs.py

Download user-requested products through the USGS TNM API

=== "Command line"

    **r.in.usgs.py**
    [**-idk**]
    **product**=*string*
    [**output_name**=*name*]
    [**ned_dataset**=*string*]
    [**input_srs**=*string*]
    [**resolution**=*float*]
    [**title_filter**=*string*]
    [**resampling_method**=*string*]
    [**memory**=*integer*]
    [**nprocs**=*integer*]
    **cache_size_tolerance**=*integer*
    [**output_directory**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.usgs.py product=string output_name=name cache_size_tolerance=20
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.usgs.py***",
        **product**,
        **output_name**=*None*,
        **ned_dataset**=*"ned1sec"*,
        **input_srs**=*None*,
        **resolution**=*None*,
        **title_filter**=*None*,
        **resampling_method**=*"default"*,
        **memory**=*300*,
        **nprocs**=*1*,
        **cache_size_tolerance**=*20*,
        **output_directory**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.usgs.py", product="string", output_name="name", cache_size_tolerance=20)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_usgs_py*(**product**,
        **output_name**=*None*,
        **ned_dataset**=*"ned1sec"*,
        **input_srs**=*None*,
        **resolution**=*None*,
        **title_filter**=*None*,
        **resampling_method**=*"default"*,
        **memory**=*300*,
        **nprocs**=*1*,
        **cache_size_tolerance**=*20*,
        **output_directory**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_usgs_py(product="string", output_name="name", cache_size_tolerance=20)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **product**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;USGS data product  
    &nbsp;&nbsp;&nbsp;&nbsp;Available USGS data products to query  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ned, naip, lidar*  
    **output_name**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **ned_dataset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;NED dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Available NED datasets to query  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ned1sec,  ned13sec,  ned19sec*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ned1sec*  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned1sec**: NED 1 arc-second  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned13sec**: NED 1/3 arc-second  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned19sec**: NED 1/9 arc-second  
    **input_srs**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input lidar dataset projection (WKT or EPSG, e.g. EPSG:4326)  
    &nbsp;&nbsp;&nbsp;&nbsp;Override input lidar dataset coordinate system using EPSG code or WKT definition  
    **resolution**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of lidar-based DSM  
    **title_filter**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter available tiles by their title (e.g. use "Phase4")  
    &nbsp;&nbsp;&nbsp;&nbsp;To avoid combining tiles from multiple years, use first -i flag and filter by tile title.  
    **resampling_method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    &nbsp;&nbsp;&nbsp;&nbsp;**default**: default method based on product  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows during import and reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes which will be used for parallel import and reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cache_size_tolerance**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance for file size difference between cached file and stated download size  
    &nbsp;&nbsp;&nbsp;&nbsp;The size difference is used to recognize failed downloads and corrupted files, but some difference occurs naturally  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **output_directory**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache directory for download and processing  
    &nbsp;&nbsp;&nbsp;&nbsp;Defaults to system user cache directory (e.g., .cache)  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Return USGS data information without downloading files  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Download files only  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep imported tiles in the mapset after patch  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **product** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;USGS data product  
    &nbsp;&nbsp;&nbsp;&nbsp;Available USGS data products to query  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ned, naip, lidar*  
    **output_name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **ned_dataset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;NED dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Available NED datasets to query  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ned1sec,  ned13sec,  ned19sec*  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned1sec**: NED 1 arc-second  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned13sec**: NED 1/3 arc-second  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned19sec**: NED 1/9 arc-second  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ned1sec*  
    **input_srs** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input lidar dataset projection (WKT or EPSG, e.g. EPSG:4326)  
    &nbsp;&nbsp;&nbsp;&nbsp;Override input lidar dataset coordinate system using EPSG code or WKT definition  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of lidar-based DSM  
    **title_filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter available tiles by their title (e.g. use "Phase4")  
    &nbsp;&nbsp;&nbsp;&nbsp;To avoid combining tiles from multiple years, use first -i flag and filter by tile title.  
    **resampling_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**default**: default method based on product  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows during import and reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes which will be used for parallel import and reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cache_size_tolerance** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance for file size difference between cached file and stated download size  
    &nbsp;&nbsp;&nbsp;&nbsp;The size difference is used to recognize failed downloads and corrupted files, but some difference occurs naturally  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **output_directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache directory for download and processing  
    &nbsp;&nbsp;&nbsp;&nbsp;Defaults to system user cache directory (e.g., .cache)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *d*, *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return USGS data information without downloading files  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Download files only  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep imported tiles in the mapset after patch  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **product** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;USGS data product  
    &nbsp;&nbsp;&nbsp;&nbsp;Available USGS data products to query  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ned, naip, lidar*  
    **output_name** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **ned_dataset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;NED dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Available NED datasets to query  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ned1sec,  ned13sec,  ned19sec*  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned1sec**: NED 1 arc-second  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned13sec**: NED 1/3 arc-second  
    &nbsp;&nbsp;&nbsp;&nbsp;**ned19sec**: NED 1/9 arc-second  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ned1sec*  
    **input_srs** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input lidar dataset projection (WKT or EPSG, e.g. EPSG:4326)  
    &nbsp;&nbsp;&nbsp;&nbsp;Override input lidar dataset coordinate system using EPSG code or WKT definition  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of lidar-based DSM  
    **title_filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter available tiles by their title (e.g. use "Phase4")  
    &nbsp;&nbsp;&nbsp;&nbsp;To avoid combining tiles from multiple years, use first -i flag and filter by tile title.  
    **resampling_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**default**: default method based on product  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows during import and reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes which will be used for parallel import and reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cache_size_tolerance** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance for file size difference between cached file and stated download size  
    &nbsp;&nbsp;&nbsp;&nbsp;The size difference is used to recognize failed downloads and corrupted files, but some difference occurs naturally  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **output_directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache directory for download and processing  
    &nbsp;&nbsp;&nbsp;&nbsp;Defaults to system user cache directory (e.g., .cache)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *d*, *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return USGS data information without downloading files  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Download files only  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep imported tiles in the mapset after patch  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.usgs* downloads and patches selected USGS datasets (NED, NAIP,
lidar) to the current GRASS computational region and coordinate
reference system. Associated parameters are automatically passed to [The
National Map Access
API](https://viewer.nationalmap.gov/tnmaccess/api/index), downloaded to
a local cache directory, then imported, and patched together.
*r.in.usgs* supports the following datasets:

- **ned**: National Elevation Dataset
- **naip**: NAIP orthoimagery
- **lidar**: Lidar Point Clouds (LPC)

National Land Cover Dataset (NLCD) is no longer available through the
API.

## NOTES

NED data are available at resolutions of 1 arc-second (about 30 meters),
1/3 arc-second (about 10 meters), and in limited areas at 1/9 arc-second
(about 3 meters).

NAIP is available at 1 m resolution.

Lidar data is available only for part of the US but there can be
multiple spatially overlapping datasets from different years. All point
clouds will be imported as points using
[v.in.pdal](https://grass.osgeo.org/grass-stable/manuals/v.in.pdal.html)
and then patched and interpolated with
[v.surf.rst](https://grass.osgeo.org/grass-stable/manuals/v.surf.rst.html).
In some cases, lidar point clouds do not have SRS information, use
**input\_srs** to specify it (e.g. "EPSG:2264"). If multiple tiles from
different years are available, use **title\_filter** to filter by their
titles (e.g. "Phase1"). Use **i** flag to list the tiles first.

If the **i** flag is set, only information about data meeting the input
parameters is displayed without downloading the data. If the **d** flag
is set, data is downloaded but not imported and processed.

By default, downloaded files are kept in a user cache directory
according to the operating system standards. These files can be reused
in case a different, but overlapping, computational region is required.
However, unzipped files and imported rasters before patching are
removed. If the **k** flag is set, extracted files from compressed
archives are also kept within the cache directory after the import. The
location of the cache directory depends on the operating system. You can
clear the cache by deleting the directory. Where this directory is
depends on operating system, for example on Linux, it is under
`~/.cache`, on macOS under `~/Library/Caches`, and on Microsoft Windows
under the Application Data directory. If you have limited space or other
special needs, you can set **output\_directory** to a custom directory,
e.g., `/tmp` on Linux. The custom directory needs to exist before
calling this module.

By default, resampling method is chosen based on the nature of the
dataset, bilinear for NED and nearest for NAIP. This can be changed with
option **resampling\_method**.

## EXAMPLE

We will download NED 1/9 arc-second digital elevation model in the
extent of raster 'elevation'. First, we just list the files to be
downloaded:

```sh
g.region raster=elevation
r.in.usgs product=ned ned_dataset=ned19sec output_name=ned -i
```

```text
USGS file(s) to download:
-------------------------
Total download size:    826.95 MB
Tile count: 4
USGS SRS:   wgs84
USGS tile titles:
USGS NED ned19_n35x75_w078x75_nc_statewide_2003 1/9 arc-second 2012 15 x 15 minute IMG
USGS NED ned19_n36x00_w078x75_nc_statewide_2003 1/9 arc-second 2012 15 x 15 minute IMG
USGS NED ned19_n35x75_w079x00_nc_statewide_2003 1/9 arc-second 2012 15 x 15 minute IMG
USGS NED ned19_n36x00_w079x00_nc_statewide_2003 1/9 arc-second 2012 15 x 15 minute IMG
-------------------------
To download USGS data, remove i flag, and rerun r.in.usgs.
```

We proceed with the download:

```sh
r.in.usgs product=ned ned_dataset=ned19sec output_name=ned
r.colors map=ned_small color=grey
```

We change the computational region to a smaller extent and create a new
DEM, downloaded files will be used.

```sh
g.region n=224649 s=222000 w=633000 e=636000
r.in.usgs product=ned ned_dataset=ned19sec output_name=ned_small
```

For a different extent we download NAIP imagery and we use a custom
cache directory (replace `/tmp` by an existing path suitable for your
operating system and needs):

```sh
g.region n=224649 s=222000 w=636000 e=639000
r.in.usgs product=naip output_directory=/tmp output_name=ortho
```

[![image-alt](r_in_usgs.png)](r_in_usgs.png)  
*Figure: Downloaded NED (large and small extent), NAIP orthoimagery, and
NLCD land cover (NLCD is not available since 2020 through the API)*

## REFERENCES

*[TNM Access API
Guide](https://viewer.nationalmap.gov/help/documents/TNMAccessAPIDocumentation/TNMAccessAPIDocumentation.pdf)  
[National Elevation Dataset](https://nationalmap.gov/elevation.html)  
[National Land Cover Dataset](https://www.mrlc.gov/)*

## SEE ALSO

*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[r.import](https://grass.osgeo.org/grass-stable/manuals/r.import.html),
[r.patch](https://grass.osgeo.org/grass-stable/manuals/r.patch.html),
[r.colors](https://grass.osgeo.org/grass-stable/manuals/r.colors.html),
[r.in.srtm](https://grass.osgeo.org/grass-stable/manuals/r.in.srtm.html),
[v.in.pdal](https://grass.osgeo.org/grass-stable/manuals/v.in.pdal.html)*

## AUTHORS

Zechariah Krautwurst, 2017 MGIST Candidate, North Carolina State
University  
(initial version, Google Summer of Code 2017, mentors: Anna Petrasova,
Vaclav Petras)

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)  
Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.in.usgs source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.in.usgs)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.in.usgs))  
Latest change: Monday Jun 30 15:22:50 2025 in commit [7d0d772](https://github.com/OSGeo/grass-addons/commit/7d0d7728d2f5408cb02ad0275e7aa80979a9b2d1)
