---
name: r.in.wcs.py
description: Downloads and imports coverage from WCS server.
keywords: [ raster, import, OGC web services ]
---

# r.in.wcs.py

Downloads and imports coverage from WCS server.

=== "Command line"

    **r.in.wcs.py**
    [**-cr**]
    **url**=*string*
    [**coverage**=*string*]
    [**urlparams**=*string*]
    [**username**=*string*]
    [**password**=*string*]
    [**output**=*string*]
    [**location**=*string*]
    [**region**=*string*]
    [**crs**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.wcs.py url=http://...?
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.wcs.py***",
        **url**=*"http://...?"*,
        **coverage**=*None*,
        **urlparams**=*None*,
        **username**=*None*,
        **password**=*None*,
        **output**=*None*,
        **location**=*None*,
        **region**=*None*,
        **crs**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.wcs.py", url="http://...?")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_wcs_py*(**url**=*"http://...?"*,
        **coverage**=*None*,
        **urlparams**=*None*,
        **username**=*None*,
        **password**=*None*,
        **output**=*None*,
        **location**=*None*,
        **region**=*None*,
        **crs**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_wcs_py(url="http://...?")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Service URL (typically http://.../mapserv? )  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *http://...?*  
    **coverage**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coverage name to request  
    **urlparams**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional query parameters to pass to the server  
    **username**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for server connection  
    **password**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for server connection  
    **output**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: coveragename)  
    **location**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new location to create  
    **region**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for region instead of current region  
    **crs**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;A valid CRS string to pass at WCS request  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Get the server capabilities then exit  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reproject raster data using r.import if needed  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Service URL (typically http://.../mapserv? )  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *http://...?*  
    **coverage** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coverage name to request  
    **urlparams** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional query parameters to pass to the server  
    **username** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for server connection  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for server connection  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: coveragename)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **location** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new location to create  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for region instead of current region  
    **crs** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A valid CRS string to pass at WCS request  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get the server capabilities then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reproject raster data using r.import if needed  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Service URL (typically http://.../mapserv? )  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *http://...?*  
    **coverage** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coverage name to request  
    **urlparams** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional query parameters to pass to the server  
    **username** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for server connection  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for server connection  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: coveragename)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **location** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new location to create  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for region instead of current region  
    **crs** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A valid CRS string to pass at WCS request  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get the server capabilities then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reproject raster data using r.import if needed  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.wcs.py* downloads and imports coverage from WCS server.

## SEE ALSO

*[r.in.wms](https://grass.osgeo.org/grass-stable/manuals/r.in.wms.html)*

## AUTHOR

Martin Zbinden

## SOURCE CODE

Available at: [r.in.wcs source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.in.wcs)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.in.wcs))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
