---
name: r.info
description: Outputs basic information about a raster map.
keywords: [ raster, metadata, extent, history ]
---

# r.info

Outputs basic information about a raster map.

=== "Command line"

    **r.info**
    [**-grseh**]
    **map**=*name*
    [**format**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.info map=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.info***",
        **map**,
        **format**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.info", map="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_info*(**map**,
        **format**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_info(map="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **format**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print raster array information  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print range  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print stats  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print extended metadata information  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print raster history instead of info  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *r*, *s*, *e*, *h*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster array information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print range  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print stats  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print extended metadata information  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster history instead of info  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *r*, *s*, *e*, *h*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster array information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print range  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print stats  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print extended metadata information  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster history instead of info  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.info* reports some basic information about a user-specified raster
map layer. This map layer must exist in the user's current mapset search
path. Information about the map's boundaries, resolution, projection,
data type, category number, project, mapset, project parent directory
(database directory), the timestamp and history are put into a table and
written to standard output. The types of information listed can also be
found in the *cats*, *cellhd*, and *hist* directories under the mapset
in which the named map is stored.

The user can save the tabular output to a file by using the UNIX
redirection mechanism (\>); for example, the user might save a report on
the *soils* map layer in a file called *soil.txt* by typing:

```sh
r.info map=soils > soil.txt
```

## NOTES

On large maps, the total number of cells in the map may not be displayed
with an accurate number. This is only cosmetic.

Some standards (ISO-C90) and compilers do not support the 'long long'
type as a 64-bit type. In the case that GRASS was built with such a
compiler, an accuracy message may be displayed in the output of *r.info*
after Total Cells.

For backwards compatibility reasons, using flags **-g**, **-e**, **-r**, **-s**
without *format*, automatically switches to the *shell* format. In the next
major release, this may be changed to keep the *plain* format output to best
serve interactive use. Specify format *shell* or *json* explicitly for
scripting.

<!-- markdownlint-disable MD046 -->
## EXAMPLES

### Get full report

Below is a full report produced by *r.info* for the raster map *slope*
in the North Carolina sample data base:

=== "Command line"

    ```sh
    r.info slope
    ```

    Possible output:

    ```text
    +----------------------------------------------------------------------------+
    | Map:      slope                          Date: Tue Nov  7 01:11:23 2006    |
    | Mapset:   PERMANENT                      Login of Creator: helena          |
    | Project:  nc_spm_08_grass7                                                 |
    | DataBase: /grassdata                                                       |
    | Title:    South-West Wake county: slope in degrees ( slope_ned10m )        |
    | Timestamp: none                                                            |
    |----------------------------------------------------------------------------|
    |                                                                            |
    |   Type of Map:  raster               Number of Categories: 255             |
    |   Data Type:    FCELL                                                      |
    |   Rows:         1350                                                       |
    |   Columns:      1500                                                       |
    |   Total Cells:  2025000                                                    |
    |        Projection: Lambert Conformal Conic                                 |
    |            N:     228500    S:     215000   Res:    10                     |
    |            E:     645000    W:     630000   Res:    10                     |
    |   Range of data:    min = 0  max = 38.68939                                |
    |                                                                            |
    |   Data Source:                                                             |
    |    raster elevation file elev_ned10m                                       |
    |                                                                            |
    |                                                                            |
    |   Data Description:                                                        |
    |    generated by r.slope.aspect                                             |
    |                                                                            |
    |   Comments:                                                                |
    |    slope map elev = elev_ned10m                                            |
    |    zfactor = 1.00 format = degrees                                         |
    |    min_slope = 0.000000                                                    |
    |                                                                            |
    +----------------------------------------------------------------------------+
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("r.info", map="slope", format="json")
    print(data["title"])
    ```

    Possible output:

    ```text
    South-West Wake county: slope in degrees
    ```

    The whole JSON may look like this:

    ```json
    {
        "north": 228500,
        "south": 215000,
        "nsres": 10,
        "east": 645000,
        "west": 630000,
        "ewres": 10,
        "rows": 1350,
        "cols": 1500,
        "cells": 2025000,
        "datatype": "FCELL",
        "ncats": 255,
        "min": 0,
        "max": 38.68939208984375,
        "n": 2019304,
        "mean": 3.864522406673347,
        "stddev": 3.0079141222181214,
        "sum": 7803645.5538851162,
        "map": "slope",
        "maptype": "raster",
        "mapset": "PERMANENT",
        "location": "nc_spm_08_grass7",
        "project": "nc_spm_08_grass7",
        "database": "/grassdata",
        "date": "Tue Nov  7 01:11:23 2006",
        "creator": "helena",
        "title": "South-West Wake county: slope in degrees",
        "timestamp": null,
        "units": null,
        "vdatum": null,
        "semantic_label": null,
        "source1": "raster elevation file elev_ned10m",
        "source2": "",
        "description": "generated by r.slope.aspect",
        "comments": "slope map elev = elev_ned10m\nzfactor = 1.00 format = degrees\nmin_slp_allowed = 0.000000"
    }
    ```

Alternatively, the output from *r.info* may be confined to a more terse
subset of the available information by passing various flags to the
module:

### Get raster array information

=== "Command line"

    ```sh
    r.info -g slope format=shell
    ```

    Possible output:

    ```text
    north=228500
    south=215000
    east=645000
    west=630000
    nsres=10
    ewres=10
    rows=1350
    cols=1500
    cells=2025000
    datatype=FCELL
    ncats=255
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("r.info", map="slope", flags="g", format="json")
    print(data)
    ```

    Possible output:

    ```text
    {'north': 228500, 'south': 215000, 'nsres': 10, 'east': 645000, 'west': 630000, 'ewres': 10, 'rows': 1350, 'cols': 1500, 'cells': 2025000, 'datatype': 'FCELL', 'ncats': 255}
    ```

Output in shell script style, useful for eval
(`` eval `r.info -g slope format=shell` ``):

### Get the map data range

=== "Command line"

    ```sh
    r.info -r slope format=shell
    ```

    Possible output:

    ```text
    min=0
    max=38.68939
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("r.info", map="slope", flags="r", format="json")
    print(data)
    ```

    Possible output:

    ```text
    {'min': 0, 'max': 38.68939208984375}
    ```

### Get extended metadata information

=== "Command line"

    ```sh
    r.info -e slope format=shell
    ```

    Possible output:

    ```text
    map=slope
    mapset=PERMANENT
    location=nc_spm_08_grass7
    project=nc_spm_08_grass7
    database=/grassdata
    date="Tue Nov  7 01:11:23 2006"
    creator="helena"
    title="South-West Wake county: slope in degrees (slope_ned10m)"
    timestamp="none"
    units="none"
    vdatum="none"
    semantic_label="none"
    source1="raster elevation file elev_ned10m"
    source2=""
    description="generated by r.slope.aspect"
    comments="slope map elev = elev_ned10mzfactor = 1.00 format = degreesmin_slp_allowed = 0.000000"
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("r.info", map="slope", flags="e", format="json")
    print(data["title"])
    ```

    Possible output:

    ```text
    South-West Wake county: slope in degrees
    ```

    The whole JSON may look like this:

    ```json
    {
        "map": "slope",
        "maptype": "raster",
        "mapset": "PERMANENT",
        "location": "nc_spm_08_grass7",
        "project": "nc_spm_08_grass7",
        "database": "/grassdata",
        "date": "Tue Nov  7 01:11:23 2006",
        "creator": "helena",
        "title": "South-West Wake county: slope in degrees",
        "timestamp": null,
        "units": null,
        "vdatum": null,
        "semantic_label": null,
        "source1": "raster elevation file elev_ned10m",
        "source2": "",
        "description": "generated by r.slope.aspect",
        "comments": "slope map elev = elev_ned10m\nzfactor = 1.00 format = degrees\nmin_slp_allowed = 0.000000"
    }
    ```
<!-- markdownlint-restore -->

## SEE ALSO

*[g.mapsets](g.mapsets.md), [r.coin](r.coin.md),
[r.describe](r.describe.md), [r.report](r.report.md),
[r.stats](r.stats.md), [r.support](r.support.md),
[r.univar](r.univar.md), [r.what](r.what.md)*

## AUTHOR

Michael O'Shea, [U.S. Army Construction Engineering Research
Laboratory](http://www.cecer.army.mil/)

## SOURCE CODE

Available at: [r.info source code](https://github.com/OSGeo/grass/tree/main/raster/r.info)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.info))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
