---
name: r.mblend.py
description: Blends two rasters of different spatial resolution.
keywords: [ raster, resolution ]
---

# r.mblend.py

Blends two rasters of different spatial resolution.

=== "Command line"

    **r.mblend.py**
    [**-a**]
    [**high**=*string*]
    [**low**=*string*]
    [**output**=*string*]
    [**far_edge**=*value*]
    [**inter_points**=*value*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mblend.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mblend.py***",
        **high**=*None*,
        **low**=*None*,
        **output**=*None*,
        **far_edge**=*95*,
        **inter_points**=*50*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mblend.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mblend_py*(**high**=*None*,
        **low**=*None*,
        **output**=*None*,
        **far_edge**=*95*,
        **inter_points**=*50*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mblend_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **high**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;High resolution input raster.  
    **low**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low resolution input raster.  
    **output**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster.  
    **far_edge**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of distance to high resolution raster used to determine far edge. Number between 0 and 100.  
    &nbsp;&nbsp;&nbsp;&nbsp;When the blending occurs along a single edge a number closer to 100 tends to produce more even results. With more blending edges (e.g. high resolution DEM sits on the middle of the low resolution DEM) a lower number may produce a more regular blend.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *95*  
    **inter_points**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of points to use in interpolation.  
    &nbsp;&nbsp;&nbsp;&nbsp;A higher number produces a smoother result but requires a lengthier computation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Assign the average difference between the two rasters to the far edge (instead of zero).  
  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **high** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;High resolution input raster.  
    **low** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low resolution input raster.  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster.  
    **far_edge** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of distance to high resolution raster used to determine far edge. Number between 0 and 100.  
    &nbsp;&nbsp;&nbsp;&nbsp;When the blending occurs along a single edge a number closer to 100 tends to produce more even results. With more blending edges (e.g. high resolution DEM sits on the middle of the low resolution DEM) a lower number may produce a more regular blend.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *95*  
    **inter_points** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of points to use in interpolation.  
    &nbsp;&nbsp;&nbsp;&nbsp;A higher number produces a smoother result but requires a lengthier computation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assign the average difference between the two rasters to the far edge (instead of zero).  
  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **high** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;High resolution input raster.  
    **low** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low resolution input raster.  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster.  
    **far_edge** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of distance to high resolution raster used to determine far edge. Number between 0 and 100.  
    &nbsp;&nbsp;&nbsp;&nbsp;When the blending occurs along a single edge a number closer to 100 tends to produce more even results. With more blending edges (e.g. high resolution DEM sits on the middle of the low resolution DEM) a lower number may produce a more regular blend.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *95*  
    **inter_points** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of points to use in interpolation.  
    &nbsp;&nbsp;&nbsp;&nbsp;A higher number produces a smoother result but requires a lengthier computation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assign the average difference between the two rasters to the far edge (instead of zero).  
  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This module implements Mblend, a DEM merging method proposed by Leitão
*et al.* (2016). It deals with cases where a study area is only
partially covered by a high resolution DEM, with a coarser DEM available
for the remainder (as in the case shown below). *r.mblend* merges the
two DEMs, producing a smooth transition from the high resolution DEM to
the low resolution DEM.  
  
![image-alt](both_inputs.png)  
  
The module works by identifying the edge between the two rasters (near
edge, shown in read below) and the edge composed by the cells in the low
resolution DEM farther away from the high resolution raster (far edge,
shown in blue below). To each point along the near edge is assigned the
difference between the two DEMs. To each point in the far edge is
assigned the value 0. The Inverse Distance Weighted (IDW) method is then
used to interpolate a new raster with the points along the two edges.
This interpolated differences raster thus trends from the full
difference at the near edge towards zero at the far edge.  
  
![image-alt](edges.png)  
  
The differences raster is finally added to the low resolution DEM given
as input. In the resulting DEM, cells along the near edge take the
values in the high resolution raster. The farther away from the near
edge (and closer to to the far edge) the closer is their value is to the
low resolution raster, producing a smooth transition, without
artefacts.  
  
![image-alt](blended.png)

## EXAMPLES

Merge the `best_dem` and `other_dem` raster maps from the current
mapset:

```sh
r.mblend high=best_dem low=other_dem output=result
```

Modifying the far edge distance cut-off:

```sh
r.mblend high=best_dem low=other_dem output=result far_edge=90
```

## REFERENCES

J.P. Leitão, L.M. de Sousa, [Towards the optimal fusion of
high-resolution Digital Elevation Models for detailed urban flood
assessment](https://doi.org/10.1016/j.jhydrol.2018.04.043), *Journal of
Hydrology*, Volume 561, June 2018, Pages 651-661, DOI:
[10.1016/j.jhydrol.2018.04.043](https://doi.org/10.1016/j.jhydrol.2018.04.043).
  
L.M. de Sousa, J.P. Leitão, [Improvements to DEM Merging with
r.mblend](http://www.scitepress.org/PublicationsDetail.aspx?ID=mcJr0zto14w=&t=1).
In *Proceedings of the 4th International Conference on Geographical
Information Systems Theory, Applications and Management - Volume 1:
GISTAM*, March 2018, pages 42-49. ISBN 978-989-758-294-3 DOI:
[10.5220/0006672500420049](https://doi.org/10.5220/0006672500420049).  
  
J.P. Leitão, D. Prodanovic, C. Maksimovic, [Improving merge methods for
grid-based digital elevation
models](https://www.sciencedirect.com/science/article/abs/pii/S0098300416300012),
*Computers & Geosciences*, Volume 88, March 2016, Pages 115-131, ISSN
0098-3004, DOI:
[10.1016/j.cageo.2016.01.001](https://doi.org/10.1016/j.cageo.2016.01.001).

## AUTHORS

Luís Moreira de Sousa  
ISRIC - World Soil Information  
João Paulo Leitão  
EAWAG: Swiss Federal Institute of Aquatic Science and Technology.

## SOURCE CODE

Available at: [r.mblend source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mblend)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mblend))  
Latest change: Wednesday Feb 26 00:42:43 2025 in commit [cd37bac](https://github.com/OSGeo/grass-addons/commit/cd37bac0690006b222682002e6775b317e694e68)
