---
name: r.null.all.py
description: Manages NULL values of raster maps in a mapset or their subset.
keywords: [ raster, map management, null data, no-data ]
---

# r.null.all.py

Manages NULL values of raster maps in a mapset or their subset.

=== "Command line"

    **r.null.all.py**
    [**-fincrzd**]
    [**setnull**=*val[-val]* [,*val[-val]*,...]]
    [**null**=*float*]
    [**pattern**=*expression* [,*expression*,...]]
    [**exclude**=*string* [,*string*,...]]
    [**matching**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.null.all.py setnull=val[-val]
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.null.all.py***",
        **setnull**=*None*,
        **null**=*None*,
        **pattern**=*None*,
        **exclude**=*None*,
        **matching**=*"all"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.null.all.py", setnull="val[-val]")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_null_all_py*(**setnull**=*None*,
        **null**=*None*,
        **pattern**=*None*,
        **exclude**=*None*,
        **matching**=*"all"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_null_all_py(setnull="val[-val]")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **setnull**=*val[-val]* [,*val[-val]*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    **null**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **pattern**=*expression* [,*expression*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name search pattern (default: all)  
    **exclude**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name exclusion pattern (default: none)  
    **matching**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Search pattern syntax  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *all, wildcards, basic, extended*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *all*  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: Match all (no pattern needed)  
    &nbsp;&nbsp;&nbsp;&nbsp;**wildcards**: Use wildcards (glob pattern)  
    &nbsp;&nbsp;&nbsp;&nbsp;**basic**: Use basic regular expressions  
    &nbsp;&nbsp;&nbsp;&nbsp;**extended**: Use extended regular expressions  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is floating-point  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is integer  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map doesn't have a NULL-value bitmap file  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create NULL-value bitmap file validating all data cells  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove NULL-value bitmap file  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Re-create NULL-value bitmap file (to compress or uncompress)  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dry run  
    &nbsp;&nbsp;&nbsp;&nbsp;Map names to be checked or processed will be printed (does not take into account other flags)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **setnull** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *val[-val]*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **pattern** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name search pattern (default: all)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *expression*  
    **exclude** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name exclusion pattern (default: none)  
    **matching** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Search pattern syntax  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *all, wildcards, basic, extended*  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: Match all (no pattern needed)  
    &nbsp;&nbsp;&nbsp;&nbsp;**wildcards**: Use wildcards (glob pattern)  
    &nbsp;&nbsp;&nbsp;&nbsp;**basic**: Use basic regular expressions  
    &nbsp;&nbsp;&nbsp;&nbsp;**extended**: Use extended regular expressions  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *all*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *i*, *n*, *c*, *r*, *z*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is floating-point  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map doesn't have a NULL-value bitmap file  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create NULL-value bitmap file validating all data cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove NULL-value bitmap file  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Re-create NULL-value bitmap file (to compress or uncompress)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dry run  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Map names to be checked or processed will be printed (does not take into account other flags)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **setnull** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *val[-val]*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **pattern** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name search pattern (default: all)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *expression*  
    **exclude** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name exclusion pattern (default: none)  
    **matching** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Search pattern syntax  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *all, wildcards, basic, extended*  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: Match all (no pattern needed)  
    &nbsp;&nbsp;&nbsp;&nbsp;**wildcards**: Use wildcards (glob pattern)  
    &nbsp;&nbsp;&nbsp;&nbsp;**basic**: Use basic regular expressions  
    &nbsp;&nbsp;&nbsp;&nbsp;**extended**: Use extended regular expressions  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *all*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *i*, *n*, *c*, *r*, *z*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is floating-point  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map doesn't have a NULL-value bitmap file  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create NULL-value bitmap file validating all data cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove NULL-value bitmap file  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Re-create NULL-value bitmap file (to compress or uncompress)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dry run  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Map names to be checked or processed will be printed (does not take into account other flags)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.null.all* manages NULL (no-data) values in all raster maps in the
current mapset. Selection can be modified using **pattern** and
**exclude** options. The option **matching** specifies the type of
search pattern use. Python users will find the extended regular
expression syntax (marked as *extended*) as most familiar, while Bash
users may want to use *wildcards* (glob patterns).

## EXAMPLES

All the following examples are using the **-d** flag to run in a *dry
run* mode so that no maps are actually modified. Set all values 1 to
NULL in all raster maps in the current mapset:

```sh
r.null.all setnull=1 -d
```

Change all NULL to zero in all raster maps in the current mapset which
begin with letter t and their name contains at least one other character
(using the extended regular expressions):

```sh
r.null.all null=0 pattern="^t.+" matching=extended -d
```

Set all values 0 to NULL in raster maps in the current mapset which do
not end with the digit 1 (using the wildcards syntax):

```sh
r.null.all setnull=0 exclude="*1" matching=wildcards -d
```

Set all values 0 to NULL in raster maps in the current mapset which do
not end with the digit 1 (using extended regular expressions):

```sh
r.null.all setnull=0 exclude=".*1" matching=extended -d
```

## SEE ALSO

*[r.null](https://grass.osgeo.org/grass-stable/manuals/r.null.html),
[g.proj.all](g.proj.all.md), [g.copyall](g.copyall.md),
[g.rename.many](g.rename.many.md)*

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.null.all source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.null.all)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.null.all))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
