---
name: r.object.spatialautocor.py
description: Spatial autocorrelation of raster objects
keywords: [ raster, statistics, spatial autocorrelation, Moran I, Geary G ]
---

# r.object.spatialautocor.py

Spatial autocorrelation of raster objects

=== "Command line"

    **r.object.spatialautocor.py**
    [**-d**]
    **object_map**=*name*
    **variable_map**=*name*
    **method**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.object.spatialautocor.py object_map=name variable_map=name method=moran
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.object.spatialautocor.py***",
        **object_map**,
        **variable_map**,
        **method**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.object.spatialautocor.py", object_map="name", variable_map="name", method="moran")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_object_spatialautocor_py*(**object_map**,
        **variable_map**,
        **method**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_object_spatialautocor_py(object_map="name", variable_map="name", method="moran")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **object_map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster input map with objects  
    **variable_map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster input map with variable  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for spatial autocorrelation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *moran, geary*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Also take into account diagonal neighbors  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **object_map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster input map with objects  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **variable_map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster input map with variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for spatial autocorrelation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *moran, geary*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also take into account diagonal neighbors  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **object_map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster input map with objects  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **variable_map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster input map with variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for spatial autocorrelation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *moran, geary*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also take into account diagonal neighbors  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.object.spatialautocor* calculates global spatial autocorrelation of
the raster objects in the *object\_map* based on the values in the
*variable\_map*. The user can choose between Moran's I or Geary's G
indicator using the *method* parameter.

At this stage, neighborhood is simply defined by an adjancy matrix. The
user can choose whether to also accept diagonal neighborhood by setting
the *-d* flag.

## NOTES

The module depends on the addon
[r.neighborhoodmatrix](r.neighborhoodmatrix.md) which needs to be
installed.

## EXAMPLE

Calculate the spatial autocorrelation of altitude in the elevation map
using individual patches in the landclass96 (North Carolina sample
dataset) as objects:

```sh
g.region raster=elevation
r.clump landclass96 output=objects
r.object.spatialautocor ob=objects var=elevation method=moran
r.object.spatialautocor ob=objects var=elevation method=geary
```

## REFERENCES

Moran, P.A.P., 1950. Notes on Continuous Stochastic Phenomena.
Biometrika 37, 17-23. <https://dx.doi.org/10.2307%2F2332142>  
  
Geary, R.C., 1954. The Contiguity Ratio and Statistical Mapping. The
Incorporated Statistician 5, 115. <https://dx.doi.org/10.2307%2F2986645>

## SEE ALSO

[r.neighborhoodmatrix](r.neighborhoodmatrix.md)  

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [r.object.spatialautocor source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.object.spatialautocor)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.object.spatialautocor))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
