---
name: r.out.maxent_swd.py
description: Exports map data as input to MaxEnt in SWD format
keywords: [ raster, export, maxent, ecology, niche ]
---

# r.out.maxent_swd.py

Exports map data as input to MaxEnt in SWD format

=== "Command line"

    **r.out.maxent_swd.py**
    [**-z**]
    [**alias_input**=*name*]
    [**env_maps**=*name* [,*name*,...]]
    [**alias_names**=*string*]
    [**bgr_output**=*name*]
    [**alias_output**=*name*]
    [**bgr_mask**=*name*]
    [**species_masks**=*name* [,*name*,...]]
    [**species_output**=*name*]
    [**species_names**=*string*]
    [**null_value**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.maxent_swd.py alias_input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.maxent_swd.py***",
        **alias_input**=*None*,
        **env_maps**=*None*,
        **alias_names**=*None*,
        **bgr_output**=*None*,
        **alias_output**=*None*,
        **bgr_mask**=*None*,
        **species_masks**=*None*,
        **species_output**=*None*,
        **species_names**=*None*,
        **null_value**=*-9999*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.maxent_swd.py", alias_input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_maxent_swd_py*(**alias_input**=*None*,
        **env_maps**=*None*,
        **alias_names**=*None*,
        **bgr_output**=*None*,
        **alias_output**=*None*,
        **bgr_mask**=*None*,
        **species_masks**=*None*,
        **species_output**=*None*,
        **species_names**=*None*,
        **null_value**=*-9999*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_maxent_swd_py(alias_input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **alias_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containg map and alias name(s) for environmental parameter(s)  
    **env_maps**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Environmental parameter map(s)  
    **alias_names**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alias names for environmental parameter map(s)  
    **bgr_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output SWD file for the environmental data of the background landscape  
    **alias_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV-like output file with alias names in first column and map names in second column, separated by comma  
    **bgr_mask**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map to be used as mask for the background landscape  
    **species_masks**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) of specie occurence  
    **species_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output SWD file for the specie(s) related environmental data  
    **species_names**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alias-name(s) for species to be used in MaxEnt SWD file instead of map names, separated by comma (default: map names).  
    **null_value**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer representing NO DATA cell value (default: -9999)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-9999*  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Zoom computational region to species data (may speed up processing)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **alias_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containg map and alias name(s) for environmental parameter(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **env_maps** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Environmental parameter map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **alias_names** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alias names for environmental parameter map(s)  
    **bgr_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output SWD file for the environmental data of the background landscape  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **alias_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV-like output file with alias names in first column and map names in second column, separated by comma  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **bgr_mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map to be used as mask for the background landscape  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **species_masks** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) of specie occurence  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **species_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output SWD file for the specie(s) related environmental data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **species_names** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alias-name(s) for species to be used in MaxEnt SWD file instead of map names, separated by comma (default: map names).  
    **null_value** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer representing NO DATA cell value (default: -9999)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-9999*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zoom computational region to species data (may speed up processing)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **alias_input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containg map and alias name(s) for environmental parameter(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **env_maps** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Environmental parameter map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **alias_names** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alias names for environmental parameter map(s)  
    **bgr_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output SWD file for the environmental data of the background landscape  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **alias_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV-like output file with alias names in first column and map names in second column, separated by comma  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **bgr_mask** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map to be used as mask for the background landscape  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **species_masks** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) of specie occurence  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **species_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output SWD file for the specie(s) related environmental data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **species_names** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alias-name(s) for species to be used in MaxEnt SWD file instead of map names, separated by comma (default: map names).  
    **null_value** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer representing NO DATA cell value (default: -9999)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-9999*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zoom computational region to species data (may speed up processing)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The script is intended to produce a set of SWD files as input to MaxEnt
\>= 3.3.3e using **r.stats**.  
  
The SWD file format is a simple CSV-like file file format as described
in Elith et al. 2011. Generally it looks like:  
*specie\_name,X,Y,parameter\_1,parameter\_2,...*

```csv
your_species,1.1,1.1,2,4.7,...
```

The first column always contains the name of the species, followed by
two columns for the X- and Y-coordinates. Then each column represents
one environmental parameter. In contrast to **r.stats** only integer
values are accepted to represent NO DATA.  
  
A background SWD file is always produced while species output can be
omitted.  
  
Multiple species can be processed, but each has to be in an individual
raster map. Map names of the maps containing the environmental
parameters can be replaced by short names, which should be used in
MaxEnt \>= 3.3.3.e.  
  
Results from MaxEnt can either be imported using **r.in.xyz** or
calculated from MaxEnt lambdas file using the **r.maxent.lambdas**.

## SEE ALSO

*[r.stats](https://grass.osgeo.org/grass-stable/manuals/r.stats.html),
[r.what](https://grass.osgeo.org/grass-stable/manuals/r.what.html),
[r.in.xyz](https://grass.osgeo.org/grass-stable/manuals/r.in.xyz.html),,
[r.maxent.lambdas](https://grass.osgeo.org/grass-stable/manuals/addons/r.maxent.lambdas.html)*

- Steven J. Phillips, Miroslav Dudík, Robert E. Schapire. 2020: Maxent
    software for modeling species niches and distributions (Version
    3.4.1). Available from url:
    <https://biodiversityinformatics.amnh.org/open_source/maxent> and
    <https://github.com/mrmaxent/Maxent>
- Steven J. Phillips, Miroslav Dudík, Robert E. Schapire. 2004: A
    maximum entropy approach to species distribution modeling. In
    Proceedings of the Twenty-First International Conference on Machine
    Learning, pages 655-662, 2004.
- Steven J. Phillips, Robert P. Anderson, Robert E. Schapire. 2006:
    Maximum entropy modeling of species geographic distributions.
    Ecological Modelling, 190:231-259, 2006.
- Jane Elith, Steven J. Phillips, Trevor Hastie, Miroslav Dudík, Yung
    En Chee, Colin J. Yates. 2011: A statistical explanation of MaxEnt
    for ecologists. Diversity and Distributions, 17:43-57, 2011.

## AUTHOR

Stefan Blumentrath, Norwegian Institute for Nature Research (NINA),
<https://www.nina.no>

## SOURCE CODE

Available at: [r.out.maxent_swd source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.out.maxent_swd)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.out.maxent_swd))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
