---
name: r.out.ntv2.py
description: Exports NTv2 datum transformation grid
keywords: [  ]
---

# r.out.ntv2.py

Exports NTv2 datum transformation grid

=== "Command line"

    **r.out.ntv2.py**
    **latshift**=*string*
    **lonshift**=*string*
    **output**=*string*
    [**systemt**=*string*]
    [**majort**=*string*]
    [**minort**=*string*]
    [**systemf**=*string*]
    [**majorf**=*string*]
    [**minorf**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.ntv2.py latshift=string lonshift=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.ntv2.py***",
        **latshift**,
        **lonshift**,
        **output**,
        **systemt**=*"WGS84"*,
        **majort**=*"6378137"*,
        **minort**=*"6356752.314245"*,
        **systemf**=*"UNKNOWN"*,
        **majorf**=*"UNKNOWN"*,
        **minorf**=*"UNKNOWN"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.ntv2.py", latshift="string", lonshift="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_ntv2_py*(**latshift**,
        **lonshift**,
        **output**,
        **systemt**=*"WGS84"*,
        **majort**=*"6378137"*,
        **minort**=*"6356752.314245"*,
        **systemf**=*"UNKNOWN"*,
        **majorf**=*"UNKNOWN"*,
        **minorf**=*"UNKNOWN"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_ntv2_py(latshift="string", lonshift="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **latshift**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of lattitude datum shift values  
    **lonshift**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of longitude datum shift values  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output NTv2 datum transformation grid file  
    **systemt**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation grid's destination coordinate system name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WGS84*  
    **majort**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Major ellipsoid axis of the transformation grid's destination coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6378137*  
    **minort**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minor ellipsoid axis of the transformation grid's destination coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6356752.314245*  
    **systemf**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation grid's input coordinate system name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **majorf**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Major ellipsoid axis of the transformation grid's input coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **minorf**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minor ellipsoid axis of the transformation grid's input coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **latshift** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of lattitude datum shift values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **lonshift** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of longitude datum shift values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output NTv2 datum transformation grid file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **systemt** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation grid's destination coordinate system name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WGS84*  
    **majort** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Major ellipsoid axis of the transformation grid's destination coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6378137*  
    **minort** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minor ellipsoid axis of the transformation grid's destination coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6356752.314245*  
    **systemf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation grid's input coordinate system name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **majorf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Major ellipsoid axis of the transformation grid's input coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **minorf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minor ellipsoid axis of the transformation grid's input coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **latshift** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of lattitude datum shift values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **lonshift** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of longitude datum shift values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output NTv2 datum transformation grid file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **systemt** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation grid's destination coordinate system name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WGS84*  
    **majort** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Major ellipsoid axis of the transformation grid's destination coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6378137*  
    **minort** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minor ellipsoid axis of the transformation grid's destination coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6356752.314245*  
    **systemf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation grid's input coordinate system name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **majorf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Major ellipsoid axis of the transformation grid's input coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **minorf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minor ellipsoid axis of the transformation grid's input coordinate system  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UNKNOWN*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.out.ntv2* converts a pair of GRASS raster maps containing longitude
and lattitude coordinate offsets into an [NTv2 grid datum
shift](https://proj.org/usage/transformation.html?highlight=nadgrids#grid-based-datum-adjustments)
file.

## NOTES

NTv2 format supports only single-precission floating point data. GRASS
GIS double-precision DCELL data need to be reduced to FCELL before
export, eg. using
[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html)
`float()` function.

The user should adjust the region and resolution to match the input
raster maps before export, using
[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html).

PROJ.4 and the software that depend on it, including GDAL, GRASS, QGIS,
assume the NTv2 grid's destination coordinate system to be WGS84. The
metadata values in the grid's header set with `majort`, `minort`,
`systemt` parameters are ignored, same as the input coordinate system
parameters (`majorf`, `minorf`, `systemf`). They are for documentation
purposes only.

The `CREATED` and `UPDATED` output grid's metadata fields are set to,
respectively, current date and time, in YYYYMMDD and HHMMSS format.

## SEE ALSO

[NTv2 format description by
ESRI](https://github.com/Esri/ntv2-file-routines)

## AUTHOR

Maciej Sieczka

## SOURCE CODE

Available at: [r.out.ntv2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.out.ntv2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.out.ntv2))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
