---
name: r.out.xyz.py
description: Exports a raster map to a text file as x,y,z values based on cell centers.
keywords: [ raster, export, output, ASCII, conversion ]
---

# r.out.xyz.py

Exports a raster map to a text file as x,y,z values based on cell centers.

=== "Command line"

    **r.out.xyz.py**
    [**-i**]
    **input**=*name* [,*name*,...]
    [**output**=*name*]
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.xyz.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.xyz.py***",
        **input**,
        **output**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.xyz.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_xyz_py*(**input**,
        **output**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_xyz_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include no data values  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include no data values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include no data values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.out.xyz* module exports a raster map as a list of x,y,z values
into an ASCII text file.

## NOTES

This module will by default not export x,y coordinates for raster cells
containing a NULL value. This includes cells masked by a raster mask.
Using the flag **-i** also these raster cells will be included in the
exported data.

This module, as all GRASS raster modules, will export cells based on the
current region settings. See the *g.region* module for details.

The *r.out.ascii* module should be used to export an array (of size row
x column) containing z values.

*r.out.xyz* can combine several input raster maps, which can be
convenient when it comes to e.g. produce ASCII point cloud files.

*r.out.xyz* is simply a front-end to "`r.stats -1g[n]`".

## EXAMPLES

In this example, a LiDAR elevation map in the North Carolina sample
dataset is exported to CSV format.

```sh
g.region raster=elev_lid792_1m -p
r.out.xyz input=elev_lid792_1m output=elev_lid792_1m.csv separator=","
```

In this example, elevation data from the North Carolina dataset are
exported along with R,G,B triplet of the related orthophoto into a
combined file (requires the import of the supplementary high-resolution
[color
orthophoto](https://grass.osgeo.org/sampledata/north_carolina/ortho2010_t792_subset_20cm.tif),
here called "ortho2010_t792"):

```sh
g.region raster=elev_lid792_1m res=1 -a -p
r.out.xyz input=elev_lid792_1m,ortho2010_t792.red,ortho2010_t792.green,ortho2010_t792.blue \
        separator=space output=pointcloud.asc

# validate: X Y Z R G B
head -n 3 pointcloud.asc
638300.5 220749.5 126.338218689 78 84 71
638301.5 220749.5 126.3381958008 93 101 86
638302.5 220749.5 126.3414840698 68 77 59
```

## TODO

Implement this script as a *r.out.ascii* option?

## SEE ALSO

*[g.region](g.region.md), [r.mask](r.mask.md)
[r.out.ascii](r.out.ascii.md), [r.stats](r.stats.md)*

## AUTHOR

M. Hamish Bowman  
*Dept. Marine Science  
Otago University, New Zealand*

## SOURCE CODE

Available at: [r.out.xyz source code](https://github.com/OSGeo/grass/tree/main/scripts/r.out.xyz)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.out.xyz))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
