---
name: r.pi.rectangle
description: Generates a rectangle based on a corner coordinate.
keywords: [ raster, landscape structure analysis, study area ]
---

# r.pi.rectangle

Generates a rectangle based on a corner coordinate.

=== "Command line"

    **r.pi.rectangle**
    **input**=*name*
    **output**=*name*
    **keyval**=*integer*
    **x**=*integer*
    **y**=*integer*
    **alignment**=*string*
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.rectangle input=name output=name keyval=0 x=0 y=0 alignment=center
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.rectangle***",
        **input**,
        **output**,
        **keyval**,
        **x**,
        **y**,
        **alignment**,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.rectangle", input="name", output="name", keyval=0, x=0, y=0, alignment="center")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_rectangle*(**input**,
        **output**,
        **keyval**,
        **x**,
        **y**,
        **alignment**,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_rectangle(input="name", output="name", keyval=0, x=0, y=0, alignment="center")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with single pixels representing sampling points  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Pixel value in the input raster to be used  
    **x**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extent of generated area on the x axis (width) in pixel  
    **y**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extent of generated area on the y axis (height) in pixel  
    **alignment**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Alignment of the rectangle relative to the input pixel. options: center, top-left, top-right, bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, top-left, top-right, bottom-left, bottom-right*  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with single pixels representing sampling points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pixel value in the input raster to be used  
    **x** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extent of generated area on the x axis (width) in pixel  
    **y** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extent of generated area on the y axis (height) in pixel  
    **alignment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alignment of the rectangle relative to the input pixel. options: center, top-left, top-right, bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, top-left, top-right, bottom-left, bottom-right*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with single pixels representing sampling points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pixel value in the input raster to be used  
    **x** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extent of generated area on the x axis (width) in pixel  
    **y** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extent of generated area on the y axis (height) in pixel  
    **alignment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alignment of the rectangle relative to the input pixel. options: center, top-left, top-right, bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, top-left, top-right, bottom-left, bottom-right*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.pi.rectangle* converts sampling points (e.g. GPS coordinates) of the
corner of a sampling site into an area by generating a defined
rectangle. Generates a rectangle based on a corner coordinate.

This modules aims at generating sampling areas which are only known by
the coordinate of one corner. The input are single points, while the
output are areas representing the corresponding area for each of the
single points/coordinates.

## NOTES

The areas can only be generated horizontally, not diagonal. This can be
added as wish and might be implemented in the future.

## EXAMPLE

An example for the North Carolina sample dataset:

```sh
g.region -d
...
```

## SEE ALSO

*[r.pi.corearea](r.pi.corearea.md), [r.pi.corr.mw](r.pi.corr.mw.md),
[r.pi.csr.mw](r.pi.csr.mw.md), [r.pi.export](r.pi.export.md),
[r.pi.graph](r.pi.graph.md), [r.pi.graph.dec](r.pi.graph.dec.md),
[r.pi.graph.pr](r.pi.graph.pr.md), [r.pi.graph.red](r.pi.graph.red.md),
[r.pi.grow](r.pi.grow.md), [r.pi.import](r.pi.import.md),
[r.pi.index](r.pi.index.md), [r.pi.lm](r.pi.lm.md),
[r.pi.odc](r.pi.odc.md), [r.pi.prob.mw](r.pi.prob.mw.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.rectangle source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.rectangle)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.rectangle))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
