---
name: r.random.weight.py
description: Generates a binary raster layer with a random selection of raster cells depending on the weight of each cell in the input weight layer.
keywords: [ raster, sampling, random ]
---

# r.random.weight.py

Generates a binary raster layer with a random selection of raster cells depending on the weight of each cell in the input weight layer.

=== "Command line"

    **r.random.weight.py**
    [**-sn**]
    **weights**=*raster*
    **output**=*raster*
    [**start**=*float*]
    [**end**=*float*]
    [**subsample**=*string*]
    [**seed**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.random.weight.py weights=raster output=raster seed=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.random.weight.py***",
        **weights**,
        **output**,
        **start**=*None*,
        **end**=*None*,
        **subsample**=*None*,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.random.weight.py", weights="raster", output="raster", seed=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_random_weight_py*(**weights**,
        **output**,
        **start**=*None*,
        **end**=*None*,
        **subsample**=*None*,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_random_weight_py(weights="raster", output="raster", seed=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **weights**=*raster* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;layer with weight  
    **output**=*raster* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;output layer  
    **start**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;minimum weight  
    **end**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum weight  
    **subsample**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;subsample  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;set seed for random number generation  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;set non-selected values to 0 (default to NULL)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **weights** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;layer with weight  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *raster*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *raster*  
    **start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;minimum weight  
    **end** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum weight  
    **subsample** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;subsample  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;set seed for random number generation  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set non-selected values to 0 (default to NULL)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **weights** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;layer with weight  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *raster*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *raster*  
    **start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;minimum weight  
    **end** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum weight  
    **subsample** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;subsample  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;set seed for random number generation  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set non-selected values to 0 (default to NULL)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.rand.weight* generates a binary raster layer with a random selection
of raster cells which are assigned 1. The other cells are assigned NULL
(or optionally 0). The change for a raster cell to get assigned a 1 (to
get selected) depends on the weight (value) of that cell in the input
weight layer.

By default the script is run setting a random seed every time. To ensure
that your results are reproducible you can set the seed value under the
'Sample options' tab. See the 'Random number generator initialization'
in the r.mapcalc helpfile for more details.

You can play with the probability for a cell to be selected by changing
the minimum and/or maximum weights. The script will give a warning if
the user defined minimum \> minimum raster value or if the user defined
maximum is smaller then the maximum raster value. The script will still
run as the user may have set this values intentionally.

You can also set the total number of sample points to be selected using
the under the 'Sample options' tab. This can be done using an absolute
number or as percentage (see the help file of the r.random function for
more details).

## Examples

See the blogpost
[weighted random sample of raster layer](https://pvanb.wordpress.com/2014/05/30/weighted_random_sample_of_raster_layer/)
for examples.

## See also

*[r.random](https://grass.osgeo.org/grass-stable/manuals/r.random.html),
[r.random.cells](https://grass.osgeo.org/grass-stable/manuals/r.random.cells.html)*

## AUTHOR

Paulo van Breugel, paulo at ecodiv.org

## SOURCE CODE

Available at: [r.random.weight source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.random.weight)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.random.weight))  
Latest change: Thursday May 29 11:23:19 2025 in commit [701c59b](https://github.com/OSGeo/grass-addons/commit/701c59b932c6a12e06ba3a4135cab5955cd9047a)
