---
name: r.rgb.py
description: Splits a raster map into red, green and blue maps.
keywords: [ raster, RGB, separate, split ]
---

# r.rgb.py

Splits a raster map into red, green and blue maps.

=== "Command line"

    **r.rgb.py**
    **input**=*name*
    [**red**=*name*]
    [**green**=*name*]
    [**blue**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.rgb.py input=name red=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.rgb.py***",
        **input**,
        **red**=*None*,
        **green**=*None*,
        **blue**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.rgb.py", input="name", red="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_rgb_py*(**input**,
        **red**=*None*,
        **green**=*None*,
        **blue**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_rgb_py(input="name", red="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **red**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Red channel raster map name  
    **green**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Green channel raster map name  
    **blue**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Blue channel raster map name  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **red** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Red channel raster map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **green** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Green channel raster map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **blue** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Blue channel raster map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **red** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Red channel raster map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **green** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Green channel raster map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **blue** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Blue channel raster map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.rgb* generates separate red, green and blue maps from a raster map
and its associated color table (grey255).

## EXAMPLE

```sh
g.region raster=elevation -p
r.rgb input=elevation red=elevation.r green=elevation.g blue=elevation.b
```

In this case *r.rgb* produces in the current mapset three new raster
maps - 'elevation.r', 'elevation.g', 'elevation.b'.

![r_rgb_elevation](r_rgb_elevation.png)

## SEE ALSO

*[r.composite](r.composite.md), [r.blend](r.blend.md),
[r.colors](r.colors.md), [r.mapcalc](r.mapcalc.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r.rgb source code](https://github.com/OSGeo/grass/tree/main/scripts/r.rgb)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.rgb))  
Latest change: Thursday Feb 20 12:48:50 2025 in commit [1633be4](https://github.com/OSGeo/grass/commit/1633be4dc57dd1819a0f6ccd8ea4bc2b8bbec864)
