---
name: r.richdem.breachdepressions.py
description: Breaches depressions using RichDEM
keywords: [ raster, hydrology ]
---

# r.richdem.breachdepressions.py

Breaches depressions using RichDEM

=== "Command line"

    **r.richdem.breachdepressions.py**
    **input**=*name*
    [**topology**=*string*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.richdem.breachdepressions.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.richdem.breachdepressions.py***",
        **input**,
        **topology**=*"D8"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.richdem.breachdepressions.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_richdem_breachdepressions_py*(**input**,
        **topology**=*"D8"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_richdem_breachdepressions_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **topology**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;D4 or D8 flow routing?  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *D4, D8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *D8*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM with depressions breached  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **topology** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;D4 or D8 flow routing?  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *D4, D8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *D8*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM with depressions breached  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **topology** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;D4 or D8 flow routing?  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *D4, D8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *D8*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM with depressions breached  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

PLACEHOLDER

## REFERENCES

PLACEHOLDER

## SEE ALSO

[r.fill.dir](https://grass.osgeo.org/grass-stable/manuals/r.fill.dir)  

## AUTHORS

Richard Barnes (algorithm and codebase), Andrew D. Wickert (GRASS
frontend)

## SOURCE CODE

Available at: [r.richdem.breachdepressions source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.richdem.breachdepressions)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.richdem.breachdepressions))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
