---
name: r.shalstab.py
description: A model for shallow landslide susceptibility.
keywords: [ raster, critical rainfall, landslide ]
---

# r.shalstab.py

A model for shallow landslide susceptibility.

=== "Command line"

    **r.shalstab.py**
    **dem**=*name*
    **phy**=*name*
    **c_soil**=*name*
    **gamma**=*name*
    **z**=*name*
    **k**=*name*
    [**root**=*name*]
    **susceptibility**=*susceptibility*
    **critic_rain**=*critical rain*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.shalstab.py dem=name phy=name c_soil=name gamma=name z=name k=name susceptibility=susceptibility critic_rain=critical rain
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.shalstab.py***",
        **dem**,
        **phy**,
        **c_soil**,
        **gamma**,
        **z**,
        **k**,
        **root**=*None*,
        **susceptibility**,
        **critic_rain**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.shalstab.py", dem="name", phy="name", c_soil="name", gamma="name", z="name", k="name", susceptibility="susceptibility", critic_rain="critical rain")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_shalstab_py*(**dem**,
        **phy**,
        **c_soil**,
        **gamma**,
        **z**,
        **k**,
        **root**=*None*,
        **susceptibility**,
        **critic_rain**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_shalstab_py(dem="name", phy="name", c_soil="name", gamma="name", z="name", k="name", susceptibility="susceptibility", critic_rain="critical rain")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **dem**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **phy**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil friction angle (angle)  
    **c_soil**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil cohesion (N/m^2)  
    **gamma**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil density(Kg/m^3)  
    **z**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical thickness of soil (m)  
    **k**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;hydraulic conductivity (m/h)  
    **root**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root cohesion k (N/m^2)  
    **susceptibility**=*susceptibility* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output landslide susceptibility map (from 1 to 7)  
    **critic_rain**=*critical rain* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output critical rainfall map (mm/day)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **dem** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **phy** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil friction angle (angle)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **c_soil** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil cohesion (N/m^2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **gamma** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil density(Kg/m^3)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **z** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical thickness of soil (m)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **k** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;hydraulic conductivity (m/h)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **root** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root cohesion k (N/m^2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **susceptibility** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output landslide susceptibility map (from 1 to 7)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *susceptibility*  
    **critic_rain** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output critical rainfall map (mm/day)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *critical rain*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **dem** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **phy** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil friction angle (angle)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **c_soil** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil cohesion (N/m^2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **gamma** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil density(Kg/m^3)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **z** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical thickness of soil (m)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **k** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;hydraulic conductivity (m/h)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **root** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root cohesion k (N/m^2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **susceptibility** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output landslide susceptibility map (from 1 to 7)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *susceptibility*  
    **critic_rain** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output critical rainfall map (mm/day)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *critical rain*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**r.shalstab** allows to apply the algorithm developed by Montgomery and
Dietrich (1994) in GRASS GIS. According to these authors, the models
associate the theories of infinite slope, where the strength of soil
share at the discretion of rupture of Mohr Coulomb, with the
hydrological model O'Loughlin (1986), resulting in equation. Requested
input and output.

The command requires some input:

- DEM a digital terrain model of the study area;
- Raster map or single value for soil cohesion (N/m^2);
- Raster map or single value for soil friction angle (°);
- Raster map or single value for soil density (kg/m^3);
- Raster map or single value for vertical thickness of soil (m);
- Raster map or single value for hydraulic conductivity k (m/h);
- Raster map or single value for root cohesion (N/m^2); (default = 0)
- Raster map or single value for wet soil density (kg/m^3). (default =
    2100)

The outputs are: A landslide susceptibility map (value range from 1 to
7):

- 1 Unconditionally Unstable
- 2 0-30 mm/day
- 3 31-100 mm/day
- 4 101-150 mm/day
- 5 151-200 mm/day
- 6 201-999 mm/day
- 7 Stable

A map for of critical rainfall map (mm/day).

## REFERENCES

Montgomery, D. R. and Dietrich, W. E.: A physically based model for the
topographic control of shallow landsliding,Water Resour. Res., 30,
1153-1171, 1994.

## AUTHORS

Andrea Filipello, University of Turin, Italy  
Daniele Strigaro, University of Milan, Italy

## SOURCE CODE

Available at: [r.shalstab source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.shalstab)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.shalstab))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
