---
name: r.slopeunits.clean.py
description: Clean results of r.slopeunits.create
keywords: [ raster, elevation, slopeunits ]
---

# r.slopeunits.clean.py

Clean results of r.slopeunits.create

=== "Command line"

    **r.slopeunits.clean.py**
    [**-mn**]
    **demmap**=*name*
    [**plainsmap**=*name*]
    **slumap**=*name*
    [**slumapclean**=*name*]
    **cleansize**=*float*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.slopeunits.clean.py demmap=name slumap=name cleansize=25000
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.slopeunits.clean.py***",
        **demmap**,
        **plainsmap**=*None*,
        **slumap**,
        **slumapclean**=*None*,
        **cleansize**=*25000*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.slopeunits.clean.py", demmap="name", slumap="name", cleansize=25000)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_slopeunits_clean_py*(**demmap**,
        **plainsmap**=*None*,
        **slumap**,
        **slumapclean**=*None*,
        **cleansize**=*25000*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_slopeunits_clean_py(demmap="name", slumap="name", cleansize=25000)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **demmap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    **plainsmap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    **slumap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input Slope Units layer (the main input)  
    **slumapclean**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer, cleaned (the main output)  
    **cleansize**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Perform quick cleaning of small-sized areas and stripes  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Perform detailed cleaning of small-sized areas (slow)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **demmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plainsmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slumap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input Slope Units layer (the main input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slumapclean** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer, cleaned (the main output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **cleansize** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform quick cleaning of small-sized areas and stripes  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform detailed cleaning of small-sized areas (slow)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **demmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plainsmap** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slumap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input Slope Units layer (the main input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slumapclean** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer, cleaned (the main output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **cleansize** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform quick cleaning of small-sized areas and stripes  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform detailed cleaning of small-sized areas (slow)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.slopeunits.clean* cleans slope units layer, e.g. results of
*r.slopeunits.create*.

## EXAMPLE

```sh
r.slopeunits.clean \
    demmap=dem_italia_isolegrandi@su_test \
    plainsmap=flat \
    slumap=su_tmp \
    slumapclean=su_tmp_cl \
    cleansize=25000 \
    -m
```

## REFERENCES

- Alvioli, M., Marchesini, I., Reichenbach, P., Rossi, M., Ardizzone,
  F., Fiorucci, F., and Guzzetti, F. (2016): Automatic delineation of
  geomorphological slope units with r.slopeunits v1.0 and their
  optimization for landslide susceptibility modeling, Geosci. Model
  Dev., 9, 3975-3991.
  DOI:[10.5194/gmd-9-3975-2016](https://doi.org/10.5194/gmd-9-3975-2016)
- Alvioli, M., Guzzetti, F., & Marchesini, I. (2020): Parameter-free
  delineation of slope units and terrain subdivision of Italy.
  Geomorphology, 358, 107124.
  DOI:[10.1016/j.geomorph.2020.107124](https://doi.org/10.1016/j.geomorph.2020.107124)

## SEE ALSO

*[r.slopeunits.create](r.slopeunits.create.md),
[r.slopeunits.metrics](r.slopeunits.metrics.md),
[r.slopeunits.optimize](r.slopeunits.optimize.md)*

## AUTHORS

Main authors: Ivan Marchesini, Massimiliano Alvioli, CNR-IRPI  
Markus Metz (refactoring, translation of "clean_method_3" to python),
Carmen Tawalika (creation of extra addon),
[mundialis](https://www.mundialis.de/)

## SOURCE CODE

Available at: [r.slopeunits.clean source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.slopeunits/r.slopeunits.clean)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.slopeunits/r.slopeunits.clean))  
Latest change: Wednesday May 07 16:16:50 2025 in commit [8af96b6](https://github.com/OSGeo/grass-addons/commit/8af96b6c1138b2b992213db3bfb2242a3e482331)
