---
name: r.stream.snap
description: Snap point to modelled stream network. Input can be stream network, point vector map with outlets or outlet coordinates.
keywords: [ raster, hydrology, stream network, basins creation ]
---

# r.stream.snap

Snap point to modelled stream network.

Input can be stream network, point vector map with outlets or outlet coordinates.

=== "Command line"

    **r.stream.snap**
    **input**=*name*
    **output**=*name*
    [**stream_rast**=*name*]
    [**accumulation**=*name*]
    [**threshold**=*float*]
    [**radius**=*integer*]
    [**memory**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.stream.snap input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.stream.snap***",
        **input**,
        **output**,
        **stream_rast**=*None*,
        **accumulation**=*None*,
        **threshold**=*-1*,
        **radius**=*1*,
        **memory**=*300*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.stream.snap", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_stream_snap*(**input**,
        **output**,
        **stream_rast**=*None*,
        **accumulation**=*None*,
        **threshold**=*-1*,
        **radius**=*1*,
        **memory**=*300*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_stream_snap(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector points map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector points map  
    **stream_rast**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with stream network  
    **accumulation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input accumulation raster map  
    **threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum accumulation threshold to snap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **radius**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance to snap (in cells)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Max memory used (MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **stream_rast** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **accumulation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input accumulation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum accumulation threshold to snap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **radius** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance to snap (in cells)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Max memory used (MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **stream_rast** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **accumulation** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input accumulation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum accumulation threshold to snap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **radius** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance to snap (in cells)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Max memory used (MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The module *r.stream.snap* is a supplementary module for
*[r.stream.extract](https://grass.osgeo.org/grass-stable/manuals/r.stream.extract.html)*
and *[r.stream.basins](r.stream.basins.md)* to correct the position of
outlets or stream initial points as they do not lie on the streamlines.

For the outlet, the point is snapped to the nearest point which lies on
the streamline.

For the stream initial points, when there is a small tributary near the
main stream, the accumulation threshold shall be high enough to force
the program ignoring this tributary and snap to the main stream. If
there is no accumulation map, the points will be snapped to the nearest
stream line, which in particular situations may be wrong. Because the
*r.stream.\** modules are prepared to work with MFD accumulation maps,
both stream network and accumulation map are necessary.

While it is assumed that the accumulation map is a MFD map, if the
stream network is not supplied, the snap point is calculated in
different way: the threshold is used to select only those points in the
search radius which have accumulation value greater than the given
threshold. The next mean value of these points is calculated and its
value is taken as a new threshold. This procedure guarantees that points
are snapped to the center of the stream tube. While for inits small
thresholds are in use, it is probable that points were snapped to the
stream tube border instead of its center.

It is strongly recommended to use both stream network (even
pre-generated with small accumulation threshold) and accumulation raster
map, than accumulation or stream raster map only.

## OPTIONS

- **stream\_rast**  
    Stream network created by
    *[r.stream.extract](https://grass.osgeo.org/grass-stable/manuals/r.stream.extract.html)*
    or
    *[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html)*.
    If used, the points are snapped to the nearest streamline point
    whose accumulation is greater than the threshold. If the
    accumulation is not used, the point is snapped to the nearest
    stream.
- **accumulation**  
    Accumulation map created with
    *[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html)*
    and used to generate the stream network with
    *[r.stream.extract](https://grass.osgeo.org/grass-stable/manuals/r.stream.extract.html)*.
    If the stream network is not used, the point is adaptively snapped
    to the point where the value is greater than mean values of
    accumulation greater than given threshold in a search radius. See
    the description for details.
- **radius**  
    Search radius (in cells). If there are no streams in the search
    radius, the point is not snapped. If there are no cells with
    accumulation greater than accumulation threshold, the point also is
    not snapped.
- **threshold**  
    Minimum value of accumulation to snap the point. This option is
    added to the snap stream inits to the stream tubes and to
    distinguish between local tributaries and main streams.
- **input**  
    Vector file containing outlets or inits as vector points. Only
    point's categories are used. Any table attached to it is ignored.
    Every point shall have its own unique category.
- **output**  
    Vector file containing outlets or inits after snapping. On layer 1,
    the original categories are preserved, on layer 2 there are four
    categories which mean:
    1. skipped (not in use yet)
    2. unresolved (points remain unsnapped due to lack of streams in
        search radius
    3. snapped (points snapped to streamlines)
    4. correct (points which remain on their original position, which
        were originally corrected)

## EXAMPLE

```sh
g.region -p -a raster=elevation
r.watershed elevation=elevation threshold=10000 drainage=dirs stream=streams accumulation=accum
# snap a point sampled in the riverine landscape to the calculated river network
r.stream.snap input=mysampleoutlet output=mysampleoutlet_snapped stream_rast=streams accumulation=accum
```

## SEE ALSO

*[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.patch](https://grass.osgeo.org/grass-stable/manuals/r.patch.html),
[r.reclass](https://grass.osgeo.org/grass-stable/manuals/r.reclass.html),
[r.stream.extract](https://grass.osgeo.org/grass-stable/manuals/r.stream.extract.html),
[r.stream.basins](r.stream.basins.md),
[r.stream.channel](r.stream.channel.md),
[r.stream.order](r.stream.order.md),
[r.stream.segment](r.stream.segment.md),
[r.stream.slope](r.stream.slope.md),
[r.stream.stats](r.stream.stats.md),
[r.stream.distance](r.stream.distance.md),
[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html)*

See also [r.streams.\*
modules](https://grasswiki.osgeo.org/wiki/R.stream.*_modules) wiki page.

## AUTHOR

Jarek Jasiewicz, Adam Mickiewicz University, Geoecology and
Geoinformation Institute.

## SOURCE CODE

Available at: [r.stream.snap source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.stream.snap)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.stream.snap))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
