---
name: r.subdayprecip.design.py
description: Computes subday design precipitation totals.
keywords: [ raster, hydrology, precipitation ]
---

# r.subdayprecip.design.py

Computes subday design precipitation totals.

=== "Command line"

    **r.subdayprecip.design.py**
    **map**=*name*
    **return_period**=*name* [,*name*,...]
    **rainlength**=*integer*
    [**area_size**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.subdayprecip.design.py map=name return_period=name rainlength=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.subdayprecip.design.py***",
        **map**,
        **return_period**,
        **rainlength**,
        **area_size**=*20*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.subdayprecip.design.py", map="name", return_period="name", rainlength=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_subdayprecip_design_py*(**map**,
        **return_period**,
        **rainlength**,
        **area_size**=*20*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_subdayprecip_design_py(map="name", return_period="name", rainlength=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of location under analysis  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **return_period**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Rainfall raster maps of required return period  
    **rainlength**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Design rainfall length in minutes  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1439*  
    **area_size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum area size to be processed (in km2, -1 for no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of location under analysis  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **return_period** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rainfall raster maps of required return period  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rainlength** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Design rainfall length in minutes  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1439*  
    **area_size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum area size to be processed (in km2, -1 for no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of location under analysis  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **return_period** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rainfall raster maps of required return period  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rainlength** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Design rainfall length in minutes  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1439*  
    **area_size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum area size to be processed (in km2, -1 for no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.subdayprecip.design* computes subday design precipitation totals
based on Hradek's method of reduction of daily maximums to chosen
duration.

The tool uses methods of zonal statistics to compute average values of
24 hours precipitation amounts of specified return period for a provided
area or a spot. Rasters of daily maxima were derived from statistics
published by Samaj et al. in 1985, which were based on precipitation
series observed in 1901-1980. Calculated average value (in millimeters)
is then reduced to the chosen length of design rain event.

## NOTES

Subday design precipitation series are important for hydrological
modelling and soil erosion problems in a small catchment scale when
designing common measures for promoting water retention, landscape
drainage systems, flood mitigation measures etc.

First automatization has been implemented by well-known method which is
based on reduction of 24 hours design precipitation to shorter time. GIS
can used for spatial supervised classification of point values of
specified return periods (2, 10, 20, 50 and 100 years).

![Basins (in orange) with orthophoto on background](r_subdayprecip_design_basin.png)  
*Figure: Basins (in orange) with orthophoto on background.*

![Return periods (2, 10, 20, 50 years) in the area of the Czech Republic](r_subdayprecip_design_h_rast.png)  
*Figure: Return periods (2, 10, 20, 50 years) in the area of the Czech Republic.*

![IV.order basins colored by mean H_N2T60 value](r_subdayprecip_design_result.png)  
*Figure: IV.order basins colored by mean H\_N2T60 value (in
millimeters)*

## EXAMPLE

```sh
r.subdayprecip.design map=basin return_period=N2,N5,N10,N20 rainlength=60
```

## REFERENCES

- Landa M., Kavka P., Strouhal L. (2015). [A GIS tool for reduction
    day precipitation to
    subday](https://web.archive.org/web/20170525233617/http://geomatica.como.polimi.it/workbooks/n12/)
    ([poster](https://www.geolab.polimi.it/wp-content/uploads/GW12_FOSS4G-eu15.pdf#page=743))
- Tomasu M. (2013). [Tvorba nastoje pro sestaveni kratkodobych
    navrhovych destu na zaklade rizene interpolace a
    redukce](https://geo.fsv.cvut.cz/proj/bp/2013/martin-tomasu-bp-2013.pdf)
    (in Czech)
- Torfs, P. J. J. F., Horacek, S., & Rakovec, O. (2010). Chimera, a
    framework for conceptual modelling using analytical sensitives to
    parameters: implementation and application to PDM model.
- Sokol, Z., & Bliznak, V. (2009). Areal distribution and
    precipitation-altitude relationship of heavy short-term
    precipitation in the Czech Republic in the warm part of the year.
    Atmospheric Research, 94(4), 652-662.

### Acknowledgement

This work has been supported by the [research project
QJ1520265](https://rain.fsv.cvut.cz) - "Variability of Short-term
Precipitation and Runoff in Small Czech Drainage Basins and its
Influence on Water Resources Management".

## SEE ALSO

*[v.rast.stats](https://grass.osgeo.org/grass-stable/manuals/v.rast.stats.html),
[v.what.rast](https://grass.osgeo.org/grass-stable/manuals/v.what.rast.html)*

## AUTHOR

Martin Landa, GeoForAll (OSGeoREL) Lab, Czech Technical University in
Prague, Czech Republic  
The module is inspired by Python script developed for Esri ArcGIS
platform by M. Tomasu in 2013.

## SOURCE CODE

Available at: [r.subdayprecip.design source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.subdayprecip.design)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.subdayprecip.design))  
Latest change: Friday Feb 21 23:33:10 2025 in commit [7c35290](https://github.com/OSGeo/grass-addons/commit/7c352906eece252043d8b84aefcbe49c88f22275)
