---
name: r.surf.gauss
description: Generates a raster map using gaussian random number generator. Mean and standard deviation of gaussian deviates can be expressed by the user.
keywords: [ raster, surface, random ]
---

# r.surf.gauss

Generates a raster map using gaussian random number generator.

Mean and standard deviation of gaussian deviates can be expressed by the user.

=== "Command line"

    **r.surf.gauss**
    **output**=*name*
    [**mean**=*float*]
    [**sigma**=*float*]
    [**seed**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.surf.gauss output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.surf.gauss***",
        **output**,
        **mean**=*0.0*,
        **sigma**=*1.0*,
        **seed**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.surf.gauss", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_surf_gauss*(**output**,
        **mean**=*0.0*,
        **sigma**=*1.0*,
        **seed**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_surf_gauss(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **mean**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distribution mean  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **sigma**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Standard deviation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mean** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distribution mean  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **sigma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Standard deviation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mean** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distribution mean  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **sigma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Standard deviation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.surf.gauss* produces a raster map of Gaussian deviates whose mean and
standard deviation can be expressed by the user. It uses a Gaussian
random number generator. It is essentially the same as
*[r.surf.random](r.surf.random.md)*, but uses a Gaussian random number
generator instead.

## EXAMPLE

```sh
g.region -p n=228500 s=215000 w=630000 e=645000 res=10
r.surf.gauss out=gauss mean=0 sigma=10

# check result
r.univar gauss
```

![r.surf.gauss example (mean: 0; sigma: 10)](r_surf_gauss.jpg)  
*Figure: Random Gaussian surface example (mean: 0; sigma: 10)*

With the histogram tool the cell values versus count can be shown.

![r.surf.gauss example histogram (mean: 0; sigma: 10)](r_surf_gauss_hist.png)  
*Figure: Histogram of random Gaussian surface example (mean: 0; sigma:
10)*

## SEE ALSO

*[r.surf.contour](r.surf.contour.md),
[r.surf.fractal](r.surf.fractal.md), [r.surf.idw](r.surf.idw.md),
[r.surf.random](r.surf.random.md), [v.surf.rst](v.surf.rst.md)*

## AUTHOR

Jo Wood, [ASSIST's
home](https://web.archive.org/web/20070707015520/http://www.le.ac.uk/assist/index.html)

## SOURCE CODE

Available at: [r.surf.gauss source code](https://github.com/OSGeo/grass/tree/main/raster/r.surf.gauss)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.surf.gauss))  
Latest change: Thursday Mar 06 19:23:31 2025 in commit [5fd4234](https://github.com/OSGeo/grass/commit/5fd4234a4f6ab09eb244c67111a1db2d84b6d0fe)
