---
name: r.texture.tiled.py
description: Runs r.texture in parallel over tiles
keywords: [ raster, texture, tiling ]
---

# r.texture.tiled.py

Runs r.texture in parallel over tiles

=== "Command line"

    **r.texture.tiled.py**
    **input**=*name*
    **output**=*basename*
    **method**=*string*
    **size**=*integer*
    **distance**=*integer*
    **tile_width**=*integer*
    **tile_height**=*integer*
    **processes**=*integer*
    [**mapset_prefix**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.texture.tiled.py input=name output=basename method=asm size=3 distance=1 tile_width=1000 tile_height=1000 processes=1
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.texture.tiled.py***",
        **input**,
        **output**,
        **method**,
        **size**=*3*,
        **distance**=*1*,
        **tile_width**=*1000*,
        **tile_height**=*1000*,
        **processes**=*1*,
        **mapset_prefix**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.texture.tiled.py", input="name", output="basename", method="asm", size=3, distance=1, tile_width=1000, tile_height=1000, processes=1)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_texture_tiled_py*(**input**,
        **output**,
        **method**,
        **size**=*3*,
        **distance**=*1*,
        **tile_width**=*1000*,
        **tile_height**=*1000*,
        **processes**=*1*,
        **mapset_prefix**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_texture_tiled_py(input="name", output="basename", method="asm", size=3, distance=1, tile_width=1000, tile_height=1000, processes=1)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*basename* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Texture method to apply  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asm, contrast, corr, var, idm, sa, sv, se, entr, dv, de, moc1, moc2*  
    **size**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of moving window (odd and &gt;= 3)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **distance**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The distance between two samples (&gt;= 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;The distance must be smaller than the size of the moving window  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tile_width**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **tile_height**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **processes**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **mapset_prefix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset prefix  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Texture method to apply  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asm, contrast, corr, var, idm, sa, sv, se, entr, dv, de, moc1, moc2*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of moving window (odd and &gt;= 3)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **distance** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The distance between two samples (&gt;= 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;The distance must be smaller than the size of the moving window  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tile_width** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **tile_height** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **processes** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **mapset_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset prefix  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Texture method to apply  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asm, contrast, corr, var, idm, sa, sv, se, entr, dv, de, moc1, moc2*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of moving window (odd and &gt;= 3)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **distance** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The distance between two samples (&gt;= 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;The distance must be smaller than the size of the moving window  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tile_width** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **tile_height** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **processes** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **mapset_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset prefix  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.texture.tiled* cuts a raster input map into tiles and runs
[r.texture](https://grass.osgeo.org/grass-stable/manuals/r.texture.html)
over these tiles before patching the result together into a single
output raster map.

The overlap between tiles is calculated internally in order to
correspond to the window **size** in order to avoid any border effects.

Tiles can be defined with the **tile\_width**, **tile\_height** and
**overlap** parameters. If **processes** is higher than one, these tiles
will be processed in parallel.

The **mapset\_prefix** parameter allows to make sure that the temporary
mapsets created during the tiled processing have unique names. This is
useful if the user runs *r.texture.tiled* several times in parallel
(e.g. in an HPC environment).

## NOTES

The parameters for texture calculation are identical to those of
[r.texture](https://grass.osgeo.org/grass-stable/manuals/r.texture.html).
Currently, this module only allows calculating one texture feature at a
time. The **n** flag allowing null cells is automatically set in order
to avoid issues at the border of the current computational region / of
the input map.

## EXAMPLE

Run r.texture over tiles with size 1000x1000 using 4 parallel processes:

```sh
g.region rast=ortho_2001_t792_1m
r.texture.tiled ortho_2001_t792_1m output=ortho_texture method=idm \
   tile_width=1000 tile_height=1000 processes=4
```

## SEE ALSO

[r.texture](https://grass.osgeo.org/grass-stable/manuals/r.texture.html)

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [r.texture.tiled source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.texture.tiled)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.texture.tiled))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
