---
name: r.windfetch.py
description: Computes wind fetch which is the length of water over which winds blow without obstruction
keywords: [ raster, distance, wind ]
---

# r.windfetch.py

Computes wind fetch which is the length of water over which winds blow without obstruction

=== "Command line"

    **r.windfetch.py**
    [**-c**]
    **input**=*name*
    [**coordinates**=*east,north* [,*east,north*,...]]
    [**points**=*name*]
    **step**=*integer*
    **direction**=*integer*
    **minor_directions**=*integer*
    **minor_step**=*integer*
    [**output_file**=*name*]
    [**format**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.windfetch.py input=name coordinates=0.0 step=15 direction=0 minor_directions=5 minor_step=3
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.windfetch.py***",
        **input**,
        **coordinates**=*None*,
        **points**=*None*,
        **step**=*15*,
        **direction**=*0*,
        **minor_directions**=*5*,
        **minor_step**=*3*,
        **output_file**=*None*,
        **format**=*"csv"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.windfetch.py", input="name", coordinates=0.0, step=15, direction=0, minor_directions=5, minor_step=3, format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_windfetch_py*(**input**,
        **coordinates**=*None*,
        **points**=*None*,
        **step**=*15*,
        **direction**=*0*,
        **minor_directions**=*5*,
        **minor_step**=*3*,
        **output_file**=*None*,
        **format**=*"csv"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_windfetch_py(input="name", coordinates=0.0, step=15, direction=0, minor_directions=5, minor_step=3, format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input land/water land use map  
    &nbsp;&nbsp;&nbsp;&nbsp;Binary input where 1 is land and 0 is water  
    **coordinates**=*east,north* [,*east,north*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for which to compute wind fetch  
    **points**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for fetch computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **step**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Angular step at which to compute wind fetch (0 is East, counterclockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15*  
    **direction**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Direction at which to start calculating fetch.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-359*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **minor_directions**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of minor directions (must be odd number).  
    &nbsp;&nbsp;&nbsp;&nbsp;Fetch computed as an average of multiple minor directions around each direction.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **minor_step**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Angular step size between minor directions.  
    &nbsp;&nbsp;&nbsp;&nbsp;Fetch computed as an average of multiple minor directions around each direction.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **output_file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *csv*  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use compass directions (0 is North, clockwise) for input direction and output  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input land/water land use map  
    &nbsp;&nbsp;&nbsp;&nbsp;Binary input where 1 is land and 0 is water  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for which to compute wind fetch  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for fetch computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **step** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angular step at which to compute wind fetch (0 is East, counterclockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15*  
    **direction** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Direction at which to start calculating fetch.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-359*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **minor_directions** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of minor directions (must be odd number).  
    &nbsp;&nbsp;&nbsp;&nbsp;Fetch computed as an average of multiple minor directions around each direction.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **minor_step** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angular step size between minor directions.  
    &nbsp;&nbsp;&nbsp;&nbsp;Fetch computed as an average of multiple minor directions around each direction.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **output_file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *csv*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use compass directions (0 is North, clockwise) for input direction and output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input land/water land use map  
    &nbsp;&nbsp;&nbsp;&nbsp;Binary input where 1 is land and 0 is water  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for which to compute wind fetch  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for fetch computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **step** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angular step at which to compute wind fetch (0 is East, counterclockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15*  
    **direction** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Direction at which to start calculating fetch.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-359*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **minor_directions** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of minor directions (must be odd number).  
    &nbsp;&nbsp;&nbsp;&nbsp;Fetch computed as an average of multiple minor directions around each direction.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **minor_step** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angular step size between minor directions.  
    &nbsp;&nbsp;&nbsp;&nbsp;Fetch computed as an average of multiple minor directions around each direction.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **output_file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *csv*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use compass directions (0 is North, clockwise) for input direction and output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The purpose of *r.windfetch* is to compute wind fetch, which is the
length of water over which winds blow without obstruction. Fetch is an
important feature in wave modeling for waves created by wind.

Input is a binary raster map **input** where land is 1 and 0 is water.
To compute fetch for certain point(s), user provides either the
coordinates with the **coordinates** parameter or a points vector map
with **points** parameter. Output is formatted with **format** parameter
either as JSON or CSV and can be printed to a file (**output\_file**) or
to standard output.

## NOTES

Wind fetch is computed for specific directions, determined by parameters
**direction** and **step**. Direction angle is in degrees
counterclockwise from the East. For example, for `direction=45` and
`step=90`, *r.windfetch* computes fetch for directions 45, 135, 225, and
315 (NE, NW, SW, SE). By default wind fetch for each direction is
averaged from multiple directions around it. The number of minor
directions from which the main direction is computed is specified with
parameter **minor\_directions**. The step between the minor directions
is given in **minor\_step** and is in degrees.

## EXAMPLE

Compute wind fetch on a lake edge with default parameters:

```sh
r.mapcalc "land = if (isnull(lakes), 1, 0)"
r.windfetch input=land format=csv coordinates=635659,223234
```

[![image-alt](r_windfetch.png)](r_windfetch.png)  
*Figure: Wind fetch for a selected point, visualized in a polar plot.*

## SEE ALSO

*[r.horizon](https://grass.osgeo.org/grass-stable/manuals/r.horizon.html)*
is used for computing distances.

## AUTHORS

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/). This addon was developed
with funding from [NSF Award
\#2322073](https://www.nsf.gov/awardsearch/showAward?AWD_ID=2322073),
granted to Natrx, Inc.

## SOURCE CODE

Available at: [r.windfetch source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.windfetch)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.windfetch))  
Latest change: Tuesday Sep 09 22:08:17 2025 in commit [c5acecd](https://github.com/OSGeo/grass-addons/commit/c5acecd432fb42dde00faf0618817896bb6e8f48)
