---
name: r.zonal.classes.py
description: Calculates zonal classes proportion describing raster areas's composition, e.g., in terms of land-cover classes.
keywords: [ raster, statistics, zonal statistics ]
---

# r.zonal.classes.py

Calculates zonal classes proportion describing raster areas's composition, e.g., in terms of land-cover classes.

=== "Command line"

    **r.zonal.classes.py**
    [**-rcnpl**]
    **zone_map**=*name*
    **raster**=*name*
    **statistics**=*string* [,*string*,...]
    [**prefix**=*string*]
    [**decimals**=*integer*]
    [**classes_list**=*string*]
    [**csvfile**=*name*]
    [**separator**=*character*]
    [**vectormap**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.zonal.classes.py zone_map=name raster=name statistics=proportion,mode csvfile=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.zonal.classes.py***",
        **zone_map**,
        **raster**,
        **statistics**=*"proportion,mode"*,
        **prefix**=*None*,
        **decimals**=*5*,
        **classes_list**=*None*,
        **csvfile**=*None*,
        **separator**=*"pipe"*,
        **vectormap**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.zonal.classes.py", zone_map="name", raster="name", statistics="proportion,mode", csvfile="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_zonal_classes_py*(**zone_map**,
        **raster**,
        **statistics**=*"proportion,mode"*,
        **prefix**=*None*,
        **decimals**=*5*,
        **classes_list**=*None*,
        **csvfile**=*None*,
        **separator**=*"pipe"*,
        **vectormap**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_zonal_classes_py(zone_map="name", raster="name", statistics="proportion,mode", csvfile="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **zone_map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with areas (all pixels of an area have same id), such as the output of r.clump  
    **raster**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input categorical raster maps for statistics  
    **statistics**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistics to calculate for each input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *proportion, mode*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *proportion,mode*  
    **prefix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for statistics name  
    **decimals**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of decimals for proportion numbers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **classes_list**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of classes to be considered in the calculation, e.g. '21,34,35,56'  
    **csvfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file containing statistics  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vectormap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional vector output map with statistics as attributes  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Adjust region to input map  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force check of input's layer type  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Consider null values in the calculations  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Proportions as percentages instead of zone's area ratio  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Compute statistics only for the classes provided in 'classes_list' parameter  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **zone_map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with areas (all pixels of an area have same id), such as the output of r.clump  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input categorical raster maps for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **statistics** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistics to calculate for each input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *proportion, mode*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *proportion,mode*  
    **prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for statistics name  
    **decimals** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of decimals for proportion numbers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **classes_list** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of classes to be considered in the calculation, e.g. '21,34,35,56'  
    **csvfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file containing statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vectormap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional vector output map with statistics as attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *c*, *n*, *p*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Adjust region to input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force check of input's layer type  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Consider null values in the calculations  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Proportions as percentages instead of zone's area ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute statistics only for the classes provided in 'classes_list' parameter  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **zone_map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with areas (all pixels of an area have same id), such as the output of r.clump  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input categorical raster maps for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **statistics** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistics to calculate for each input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *proportion, mode*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *proportion,mode*  
    **prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for statistics name  
    **decimals** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of decimals for proportion numbers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **classes_list** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of classes to be considered in the calculation, e.g. '21,34,35,56'  
    **csvfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file containing statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vectormap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional vector output map with statistics as attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *c*, *n*, *p*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Adjust region to input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force check of input's layer type  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Consider null values in the calculations  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Proportions as percentages instead of zone's area ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute statistics only for the classes provided in 'classes_list' parameter  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.zonal.classes* computes class proportions and majority class (mode)
of a "cover layer" (provided via the **raster** parameter) - e.g. a land
cover map - according to how it intersects with areas/objects in a "base
layer" (provided via the **zone\_map** parameter). Areas are defined by
adjacent pixels with the same value, such as those obtained with
*[r.clump](https://grass.osgeo.org/grass-stable/manuals/r.clump.html)*
or
*[i.segment](https://grass.osgeo.org/grass-stable/manuals/i.segment.html)*.

This function is similar to
*[r.stats.zonal](https://grass.osgeo.org/grass-stable/manuals/r.stats.zonal.html)*,
but is intended to be used on a categorical raster with integer values
(CELL type) instead of floating point as in *r.stats.zonal*.

## NOTES

The user can choose between output in the form of a vector map of the
areas contained in the "base layer" with the statistics of the "cover
layer" stored in the attribute table (the name of the vector layer
should be provided via the **vectormap** parameter) and/or in the form
of a CSV text file (the path to the file should be provided via the
**csvfile** parameter).

By default:

- the function compute the majority class as well as class proportions
    for each zone in the "base layer". If only the majority class or
    class proportion is needed, it can be specified by using the
    **statistics** parameter.
- the function provides the ratio of classes (total = 1) but the
    **-p** flag allows providing percentages (total = 100). The number
    of decimals is set to 5 by default and can be changed using the
    **decimals** parameter.
- the name of columns for proportions follows this logic : 'prop\_XX'
    where XX is the class of the "base layer". The user can add a prefix
    to proportion columns using the **prefix** parameter.
- the function works under the current computation region. The **-r**
    flag can be used to define the computational region based on the
    "base layer" for the processing.
- the function ignores NULL values in statistics computation. This
    behaviour can be reverted using the **-n** flag.
- the function provides proportion columns only for classes that
    actually exist in the "base layer" under the current computational
    region. This can create problems when the user run the function on
    different computational region with the aim to merge outputs at the
    end, because some classes could be present under some computational
    regions and absent on others. The **classes\_list** parameter and
    the **-l** flag allow to alleviate this issue. The **-l** flag force
    the output to provide statistics only for classes provided via the
    **classes\_list** parameter. When the **classes\_list** parameter is
    provided **without the -l flag**, the output will contain in
    addition to the classes that actually exist in the "base layer"
    under the current computational region (the default behaviour)
    columns for classes in the provided via the **classes\_list**
    parameter which will be filled with zero value. This is particularly
    useful when the function is used in multiple processing -
    sequentially or in parallel - to ensure all the output will have the
    same number (and order) of columns. Please notice that the
    computation of the mode is not affected by the list of classes
    provided in the **classes\_list** parameter.
- there is no check for the type of input's raster which is intended
    to be "CELL". This behaviour can be reversed using the **-c** flag.

## EXAMPLES

On North Carolina sample dataset:

```sh
# Define region
g.region raster=zipcodes

# Get majority class and class proportion of 'landuse96_28m'
# for each zone/object in 'zipcode' layer
r.zonal.classes zone_map=zipcodes raster=landuse96_28m csvfile=output.csv \
  vectormap=vect_output

# Display attributes table
v.db.select map=vect_output

cat mode    prop_0  prop_1   ...    prop_21
27511   18  0.00009 0.11286  ...    0.00000
27513   15  0.00000 0.06098  ...    0.00000
27518   15  0.00000 0.06455  ...    0.00000
27529   15  0.00000 0.24149  ...    0.00000
... ... ... ...  ...    ...

# Get only class proportion (not the mode), add prefix on columns and
# return proportion as percentages instead of the zone's area ratio
r.zonal.classes zone_map=zipcodes raster=landuse96_28m csvfile=output.csv \
  vectormap=vect_output prefix=lu statistics=proportion -p

# Display attributes table
v.db.select map=vect_output

cat lu_prop_0   lu_prop_1   ... lu_prop_21
27511   0.00851     11.28639    ... 0.00000
27513   0.00000     6.09839     ... 0.00000
27518   0.00000     6.45485     ... 0.00000
27529   0.00000     24.14926    ... 0.00000
... ...     ...     ...  ...

# Ensure that a column is created for class '1234' even if it doesn't exist
# under the current computational region
r.zonal.classes zone_map=zipcodes raster=landuse96_28m csvfile=output.csv \
  vectormap=vect_output prefix=lu classes_list='1234'

# Display attributes table
v.db.select map=vect_output

cat lu_mode lu_prop_0   ... lu_prop_21  lu_prop_1234
27511   18  0.00009     ... 0.00000     0.00000
27513   15  0.00000     ... 0.00000     0.00000
27518   15  0.00000     ... 0.00000     0.00000
... ... ...     ...  ...        ...

# Output only the proportion columns for classes '4,12,1234'
r.zonal.classes zone_map=zipcodes raster=landuse96_28m csvfile=output.csv \
  vectormap=vect_output classes_list='4,12,1234' -l

# Display attributes table
v.db.select map=vect_output

cat mode    prop_4      prop_12 prop_1234
27511   18  0.02310     0.00000 0.00000
27513   15  0.02888     0.00000 0.00000
27518   15  0.06291     0.00000 0.00000
27529   15  0.02579     0.00000 0.00000
... ... ...     ...  ...
```

### Acknowledgement

This work was funded by the Belgian Federal Science Policy Office
(BELSPO) (Research Program for Earth Observation [STEREO
III](https://eo.belspo.be/About/Stereo3.aspx), contract SR/00/304) as
part of the [MAUPP project](https://maupp.ulb.ac.be) and by [the
department of Geomatics of the Walloon
region](https://geoportail.wallonie.be) as part of the WALOUS project.

## SEE ALSO

*[r.stats.zonal](https://grass.osgeo.org/grass-stable/manuals/r.stats.zonal.html),
[r.univar](https://grass.osgeo.org/grass-stable/manuals/r.univar.html),
[v.rast.stats](https://grass.osgeo.org/grass-stable/manuals/v.rast.stats.html),
[i.segment.stats (Addon)](i.segment.stats.md),*

## AUTHOR

Tais GRIPPA - Universite Libre de Bruxelles. ANAGEO Lab.

## SOURCE CODE

Available at: [r.zonal.classes source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.zonal.classes)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.zonal.classes))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
