---
name: r3.forestfrag.py
description: Computes the forest fragmentation index (Riitters et al. 2000)
keywords: [ raster3d, landscape structure analysis, vegetation structure analysis, forest, fragmentation index, Riitters ]
---

# r3.forestfrag.py

Computes the forest fragmentation index (Riitters et al. 2000)

=== "Command line"

    **r3.forestfrag.py**
    [**-rta**]
    **input**=*name*
    **output**=*name*
    **size**=*number*
    [**pf**=*name*]
    [**pff**=*name*]
    **transitional_limit**=*float*
    **patch_limit**=*float*
    [**interior_limit**=*float*]
    [**color**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.forestfrag.py input=name output=name size=3 transitional_limit=0.6 patch_limit=0.4
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.forestfrag.py***",
        **input**,
        **output**,
        **size**=*3*,
        **pf**=*None*,
        **pff**=*None*,
        **transitional_limit**=*0.6*,
        **patch_limit**=*0.4*,
        **interior_limit**=*None*,
        **color**=*"sambale"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.forestfrag.py", input="name", output="name", size=3, transitional_limit=0.6, patch_limit=0.4)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_forestfrag_py*(**input**,
        **output**,
        **size**=*3*,
        **pf**=*None*,
        **pff**=*None*,
        **transitional_limit**=*0.6*,
        **patch_limit**=*0.4*,
        **interior_limit**=*None*,
        **color**=*"sambale"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_forestfrag_py(input="name", output="name", size=3, transitional_limit=0.6, patch_limit=0.4)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of forest raster map (where forest=1, non-forest=0)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **size**=*number* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Moving window size (odd number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **pf**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output Pf (forest area density) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Proportion of area which is forested (amount of forest)  
    **pff**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output Pff (forest connectivity) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Conditional probability that neighboring cell is forest  
    **transitional_limit**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;transitional_limit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.6*  
    **patch_limit**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;patch_limit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **interior_limit**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;interior_limit  
    **color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Source raster for colorization  
    &nbsp;&nbsp;&nbsp;&nbsp;Input and color_input are taken from input and color_input options respectively. The rest is computed using r.slope.aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sambale, riitters, perceptual*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sambale*  
    &nbsp;&nbsp;&nbsp;&nbsp;**sambale**: Sambale, Stefan Sylla  
    &nbsp;&nbsp;&nbsp;&nbsp;**riitters**:  Riitters et. al 2000  
    &nbsp;&nbsp;&nbsp;&nbsp;**perceptual**: Perceptually uniform  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set computational region to input raster map  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep Pf and Pff maps  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Trim the output map to avoid border effects  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of forest raster map (where forest=1, non-forest=0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Moving window size (odd number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *number*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **pf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output Pf (forest area density) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Proportion of area which is forested (amount of forest)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **pff** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output Pff (forest connectivity) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Conditional probability that neighboring cell is forest  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **transitional_limit** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;transitional_limit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.6*  
    **patch_limit** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;patch_limit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **interior_limit** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;interior_limit  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Source raster for colorization  
    &nbsp;&nbsp;&nbsp;&nbsp;Input and color_input are taken from input and color_input options respectively. The rest is computed using r.slope.aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sambale, riitters, perceptual*  
    &nbsp;&nbsp;&nbsp;&nbsp;**sambale**: Sambale, Stefan Sylla  
    &nbsp;&nbsp;&nbsp;&nbsp;**riitters**:  Riitters et. al 2000  
    &nbsp;&nbsp;&nbsp;&nbsp;**perceptual**: Perceptually uniform  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sambale*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *t*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set computational region to input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep Pf and Pff maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Trim the output map to avoid border effects  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of forest raster map (where forest=1, non-forest=0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Moving window size (odd number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *number*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **pf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output Pf (forest area density) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Proportion of area which is forested (amount of forest)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **pff** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output Pff (forest connectivity) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Conditional probability that neighboring cell is forest  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **transitional_limit** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;transitional_limit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.6*  
    **patch_limit** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;patch_limit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **interior_limit** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;interior_limit  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Source raster for colorization  
    &nbsp;&nbsp;&nbsp;&nbsp;Input and color_input are taken from input and color_input options respectively. The rest is computed using r.slope.aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sambale, riitters, perceptual*  
    &nbsp;&nbsp;&nbsp;&nbsp;**sambale**: Sambale, Stefan Sylla  
    &nbsp;&nbsp;&nbsp;&nbsp;**riitters**:  Riitters et. al 2000  
    &nbsp;&nbsp;&nbsp;&nbsp;**perceptual**: Perceptually uniform  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sambale*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *t*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set computational region to input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep Pf and Pff maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Trim the output map to avoid border effects  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

TODO: Create a description specific for 3D version *r.forestfrag*
Computes the forest fragmentation following the methodology proposed by
Riitters et. al (2000). See [this
article](http://www.consecol.org/vol4/iss2/art3/) for a detailed
explanation.

It follows a "sliding window" algorithm with overlapping windows. The
amount of forest and its occurence as adjacent forest pixels within
fixed- area "moving-windows" surrounding each forest pixel is measured.
The window size is user-defined. The result is stored at the location of
the center pixel. Thus, a pixel value in the derived map refers to
"between-pixel" fragmentation around the corresponding forest location.

As input it requires a binary map with (1) forest and (0) non-forest.
Obviously, one can replace forest any other land cover type. If one
wants to exclude the influence of a specific land cover type, e.g.,
water bodies, it should be classified as no-data (NA) in the input map.
See e.g., [blog
post](https://pvanb.wordpress.com/2016/03/25/update-of-r-forestfrag-addon/).

Let *Pf* be the proportion of pixels in the window that are forested.
Define *Pff* (strictly) as the proportion of all adjacent (cardinal
directions only) pixel pairs that include at least one forest pixel, for
which both pixels are forested. *Pff* thus (roughly) estimates the
conditional probability that, given a pixel of forest, its neighbor is
also forest. The classification model then identifies six fragmentation
categories as:

```text
interior:       Pf = 1.0
patch:          Pf < 0.4
transitional:   0.4 ≤ Pf < 0.6
edge:           Pf ≥ 0.6 and Pf - Pff < 0
perforated:     Pf ≥ 0.6 and Pf - Pff > 0
undetermined:   Pf ≥ 0.6 and Pf = Pff
```

## NOTES

- The moving window size is user-defined (default=3) and must be an
    odd number. If an even number is given the function will stop with
    an error message.
- No-data cells are ignored. This means that statistics at the raster
    edges are based on fewer cells (smaller) moving windows. If this is
    a problem, the user can choose to have the output raster trimmed
    with a number of raster cells equal to 1/2 \* the size of the moving
    window.
- The function respects the region. The user has however the option to
    set the region to match the input layer.

## REFERENCES

Petras, V., Newcomb D. J., Mitasova, H. 2017. *Generalized 3D
fragmentation index derived from lidar point clouds.* Open Geospatial
Data, Software and Standards 2017 2:9
DOI: [10.1186/s40965-017-0021-8](https://dx.doi.org/10.1186/s40965-017-0021-8)  
Riitters, K., J. Wickham, R. O'Neill, B. Jones, and E. Smith. 2000.
*Global-scale patterns of forest fragmentation.* Conservation Ecology
4(2): 3. \[online\] URL: <http://www.consecol.org/vol4/iss2/art3/>

## SEE ALSO

*[r3.count.categories](r3.count.categories.md),
[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[r.forestfrag](r.forestfrag.md)*

## AUTHORS

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)  
Paulo van Breugel, main author of the 2D version
(*[r.forestfrag](r.forestfrag.md)*)

## SOURCE CODE

Available at: [r3.forestfrag source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster3d/r3.forestfrag)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster3d/r3.forestfrag))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
