---
name: r3.in.v5d
description: Import 3-dimensional Vis5D files.
keywords: [ raster3d, import, voxel ]
---

# r3.in.v5d

Import 3-dimensional Vis5D files.

=== "Command line"

    **r3.in.v5d**
    **input**=*name*
    **output**=*name*
    [**null_value**=*string*]
    [**type**=*string*]
    [**precision**=*string*]
    [**compression**=*string*]
    [**tiledimension**=*XxYxZ*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.in.v5d input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.in.v5d***",
        **input**,
        **output**,
        **null_value**=*"none"*,
        **type**=*"default"*,
        **precision**=*"default"*,
        **compression**=*"default"*,
        **tiledimension**=*"default"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.in.v5d", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_in_v5d*(**input**,
        **output**,
        **null_value**=*"none"*,
        **type**=*"default"*,
        **precision**=*"default"*,
        **compression**=*"default"*,
        **tiledimension**=*"default"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_in_v5d(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of V5D raster file to be imported  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, double, float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **precision**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits used as mantissa in the internal map storage, 0 -23 for float, 0 - 52 for double, max or default  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **compression**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The compression method used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, zip, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **tiledimension**=*XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of V5D raster file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, double, float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **precision** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits used as mantissa in the internal map storage, 0 -23 for float, 0 - 52 for double, max or default  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **compression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The compression method used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, zip, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **tiledimension** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of V5D raster file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, double, float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **precision** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits used as mantissa in the internal map storage, 0 -23 for float, 0 - 52 for double, max or default  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **compression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The compression method used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, zip, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **tiledimension** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.in.v5d* imports 3-dimensional files (i.e. the V5D file with one
variable and one time step). Otherwise, only first variable and timestep
from 4/5D V5D file will be imported.

[Vis5D](https://vis5d.sourceforge.net/) is a system for interactive
visualization of large 5D gridded data sets such as those produced by
numerical weather models. The user can make isosurfaces, contour line
slices, colored slices, volume renderings, etc. of data in a 3D raster
map, then rotate and animate the images in real time. There's also a
feature for wind trajectory tracing, a way to make text annotations for
publications, support for interactive data analysis, etc.

## SEE ALSO

*[r3.out.v5d](r3.out.v5d.md)*

## AUTHOR

Jaro Hofierka, GeoModel s.r.o., Slovakia

## SOURCE CODE

Available at: [r3.in.v5d source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.in.v5d)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.in.v5d))  
Latest change: Friday Mar 07 07:39:48 2025 in commit [e1e37d8](https://github.com/OSGeo/grass/commit/e1e37d87e78212dfcf4c97aaf32c54042adbd2b0)
