---
name: r3.out.bin
description: Exports a GRASS 3D raster map to a binary array.
keywords: [ raster3d, export, voxel ]
---

# r3.out.bin

Exports a GRASS 3D raster map to a binary array.

=== "Command line"

    **r3.out.bin**
    [**-rdi**]
    **input**=*name*
    **output**=*name*
    [**null**=*float*]
    **bytes**=*integer*
    [**order**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.out.bin input=name output=name bytes=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.out.bin***",
        **input**,
        **output**,
        **null**=*0*,
        **bytes**,
        **order**=*"native"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.out.bin", input="name", output="name", bytes=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_out_bin*(**input**,
        **output**,
        **null**=*0*,
        **bytes**,
        **order**=*"native"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_out_bin(input="name", output="name", bytes=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **null**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to write out for null  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bytes**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output byte order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Write data as integer  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to write out for null  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bytes** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output byte order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write data as integer  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to write out for null  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bytes** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output byte order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write data as integer  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r3.out.bin* program exports a GRASS 3D raster map to a binary array
file. Optionally, output can be send to standard output (stdout) for
direct input (pipe) into other applications. Data is exported according
to the original GRASS 3D raster type (float, double).

## NOTES

The write order of the rows (north-\>south to south-\>north) and the
write order of the depths (bottom-\>top to top-\>bottom) can be
switched.

The region parameters are printed to stderr when setting the verbose
flag. Export of little and big endian byte order is supported.

Have a look at [r3.out.ascii](r3.out.ascii.md) manual page that
describes the internal layout of the 3D raster maps and the supported
row and depth switch options.

## EXAMPLES

Have a look at the examples in [r3.in.bin](r3.in.bin.md).

## SEE ALSO

*[r3.in.bin](r3.in.bin.md), [r3.in.ascii](r3.in.ascii.md)*

## AUTHOR

Sören Gebbert, based on r.out.bin from Bob Covill and Glynn Clements

## SOURCE CODE

Available at: [r3.out.bin source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.out.bin)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.out.bin))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
