---
title: 3D raster tools
author: GRASS Development Team
---

# 3D raster tools

To learn more about these tool in general, go to [3D raster introduction](raster3dintro.md).

| Name | Description |
|--------|-------------|
| [r3.colors](r3.colors.md) | Creates/modifies the color table associated with a 3D raster map. |
| [r3.colors.out](r3.colors.out.md) | Exports the color table associated with a 3D raster map. |
| [r3.cross.rast](r3.cross.rast.md) | Creates cross section 2D raster map from 3D raster map based on 2D elevation map |
| [r3.flow](r3.flow.md) | Computes 3D flow lines and 3D flow accumulation. |
| [r3.gradient](r3.gradient.md) | Computes gradient of a 3D raster map and outputs gradient components as three 3D raster maps. |
| [r3.gwflow](r3.gwflow.md) | Numerical calculation program for transient, confined groundwater flow in three dimensions. |
| [r3.in.ascii](r3.in.ascii.md) | Converts a 3D ASCII raster text file into a (binary) 3D raster map. |
| [r3.in.bin](r3.in.bin.md) | Imports a binary raster file into a GRASS 3D raster map. |
| [r3.in.lidar](r3.in.lidar.md) | Creates a 3D raster map from LAS LiDAR points using univariate statistics. |
| [r3.in.v5d](r3.in.v5d.md) | Import 3-dimensional Vis5D files. |
| [r3.in.xyz](r3.in.xyz.md) | Create a 3D raster map from an assemblage of many coordinates using univariate statistics |
| [r3.info](r3.info.md) | Outputs basic information about a user-specified 3D raster map layer. |
| [r3.mapcalc](r3.mapcalc.md) | Raster map calculator. |
| [r3.mask](r3.mask.md) | Establishes the current working 3D raster mask. |
| [r3.mkdspf](r3.mkdspf.md) | Creates a display file from an existing 3D raster map according to specified threshold levels. |
| [r3.neighbors](r3.neighbors.md) | Makes each voxel value a function of the values assigned to the voxels around it, and stores new voxel values in an output 3D raster map |
| [r3.null](r3.null.md) | Explicitly create the 3D NULL-value bitmap file. |
| [r3.out.ascii](r3.out.ascii.md) | Converts a 3D raster map layer into a ASCII text file. |
| [r3.out.bin](r3.out.bin.md) | Exports a GRASS 3D raster map to a binary array. |
| [r3.out.netcdf](r3.out.netcdf.md) | Export a 3D raster map as netCDF file. |
| [r3.out.v5d](r3.out.v5d.md) | Exports GRASS 3D raster map to 3-dimensional Vis5D file. |
| [r3.out.vtk](r3.out.vtk.md) | Converts 3D raster maps into the VTK-ASCII format. |
| [r3.retile](r3.retile.md) | Retiles an existing 3D raster map with user defined x, y and z tile size. |
| [r3.stats](r3.stats.md) | Generates volume statistics for 3D raster maps. |
| [r3.support](r3.support.md) | Allows creation and/or modification of 3D raster map layer support files. |
| [r3.timestamp](r3.timestamp.md) | Modifies a timestamp for a 3D raster map. Print/add/remove a timestamp for a 3D raster map. |
| [r3.to.rast](r3.to.rast.md) | Converts 3D raster maps to 2D raster maps |
| [r3.univar](r3.univar.md) | Calculates univariate statistics from the non-null cells of a 3D raster map. Statistics include number of cells counted, minimum and maximum cell values, range, arithmetic mean, population variance, standard deviation, coefficient of variation, and sum. |
