---
name: t.list.py
description: Lists space time datasets and maps registered in the temporal database.
keywords: [ temporal, map management, list, time ]
---

# t.list.py

Lists space time datasets and maps registered in the temporal database.

=== "Command line"

    **t.list.py**
    [**-c**]
    [**type**=*string*]
    [**temporaltype**=*name* [,*name*,...]]
    [**order**=*string* [,*string*,...]]
    [**columns**=*string* [,*string*,...]]
    [**where**=*sql_query*]
    [**separator**=*character*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.list.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.list.py***",
        **type**=*"strds"*,
        **temporaltype**=*"absolute,relative"*,
        **order**=*"id"*,
        **columns**=*"id"*,
        **where**=*None*,
        **separator**=*"pipe"*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.list.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_list_py*(**type**=*"strds"*,
        **temporaltype**=*"absolute,relative"*,
        **order**=*"id"*,
        **columns**=*"id"*,
        **where**=*None*,
        **separator**=*"pipe"*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_list_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the space time dataset or map, default is strds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds,  raster,  raster_3d,  vector*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **temporaltype**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *absolute, relative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *absolute,relative*  
    **order**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns number_of_maps and granularity only available for space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, semantic_label, creator, mapset, number_of_maps, creation_time, start_time, end_time, interval, north, south, west, east, granularity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *id*  
    **columns**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns number_of_maps and granularity only available for space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, semantic_label, creator, mapset, number_of_maps, creation_time, start_time, end_time, north, south, west, east, granularity, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *id*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the column names as first row  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the space time dataset or map, default is strds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds,  raster,  raster_3d,  vector*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **temporaltype** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *absolute, relative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *absolute,relative*  
    **order** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns number_of_maps and granularity only available for space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, semantic_label, creator, mapset, number_of_maps, creation_time, start_time, end_time, interval, north, south, west, east, granularity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *id*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns number_of_maps and granularity only available for space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, semantic_label, creator, mapset, number_of_maps, creation_time, start_time, end_time, north, south, west, east, granularity, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *id*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the column names as first row  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the space time dataset or map, default is strds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds,  raster,  raster_3d,  vector*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **temporaltype** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *absolute, relative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *absolute,relative*  
    **order** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns number_of_maps and granularity only available for space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, semantic_label, creator, mapset, number_of_maps, creation_time, start_time, end_time, interval, north, south, west, east, granularity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *id*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns number_of_maps and granularity only available for space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, semantic_label, creator, mapset, number_of_maps, creation_time, start_time, end_time, north, south, west, east, granularity, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *id*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the column names as first row  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.list* lists any dataset that is registered in the temporal database.
Datasets are raster, 3D raster and vector maps as well as their
corresponding space time datasets (STRDS, STR3DS and STVDS). The type of
the dataset can be specified using the *type* option, default is STRDS.
By default all datasets with relative and absolute time are listed.
However, the user has the ability to specify a single temporal type with
the *temporaltype* option. The user can define the columns that should
be printed for each dataset and the order of the datasets. In addition a
SQL WHERE statement can be specified to select a subset of the requested
datasets.

## NOTES

The SQL *where* and *sort* expression will be applied for each temporal
database that was found in accessible mapsets. Hence sorting works only
on mapset basis.

Temporal databases stored in other mapsets can be used as long as they
are in the user's current mapset search path (managed with
[g.mapsets](g.mapsets.md)).

## EXAMPLES

Obtain the list of space time raster dataset(s):

```sh
t.list strds
----------------------------------------------
Space time raster datasets with absolute time available in mapset <climate_2000_2012>:
tempmean_monthly@climate_2000_2012
```

Obtain the list of space time raster datasets in a specific mapset (Note
that the target mapset must be in the user's search path):

```sh
# strds in PERMANENT
t.list strds where="mapset = 'PERMANENT'"
----------------------------------------------

# strds in climate_2000_2012
t.list strds where="mapset = 'climate_2000_2012'"
----------------------------------------------
Space time raster datasets with absolute time available in mapset <climate_2000_2012>:
precip_abs@climate_2000_2012
precipitation@climate_2000_2012
tempmean@climate_2000_2012
```

The *where* option can also be used to list the stds with a certain
pattern in their name, i.e. as the pattern option in
[g.list](g.list.md).

```sh
# strds whose name start with "precip"
t.list type=strds where="name LIKE 'precip%'"
----------------------------------------------
Space time raster datasets with absolute time available in mapset <climate_1970_2012>:
precip_abs@climate_1970_2012
precipitation@climate_1970_2012
```

The user can also obtain the list of time stamped raster maps. These
maps might be registered in strds or not. The output of the following
command can vary according to the accessible mapsets specified through
[g.mapsets](g.mapsets.md).

```sh
t.list raster
Time stamped raster maps with absolute time available in mapset <climate_2000_2012>:
2009_01_tempmean@climate_2000_2012
2009_02_tempmean@climate_2000_2012
2009_03_tempmean@climate_2000_2012
...
2012_10_tempmean@climate_2000_2012
2012_11_tempmean@climate_2000_2012
2012_12_tempmean@climate_2000_2012
```

## SEE ALSO

*[g.list](g.list.md), [t.create](t.create.md), [t.info](t.info.md),
[t.rast.list](t.rast.list.md), [t.rast3d.list](t.rast3d.list.md),
[t.vect.list](t.vect.list.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.list source code](https://github.com/OSGeo/grass/tree/main/temporal/t.list)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.list))  
Latest change: Friday Feb 14 09:52:49 2025 in commit [4173c3d](https://github.com/OSGeo/grass/commit/4173c3d8bfb55ed09ca87d3239f1a737d5b791bc)
